/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BTreeEntryID;
import com.sonicsw.mtstorage.impl.BTreeIteratorState;
import com.sonicsw.mtstorage.impl.BTreeManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

final class BTreeSnapshot {
    private HashMap m_treesOfDeleted;
    private HashMap m_treesLifeCycle;
    private HashSet m_treesOfInserted;
    Long m_snapshotTransID;
    BTreeManager m_sShotBtreeManager;

    BTreeSnapshot(BTreeManager sShotBtreeManager, Long snapshotTransID) {
        this.m_sShotBtreeManager = sShotBtreeManager;
        this.m_snapshotTransID = snapshotTransID;
        this.m_treesOfDeleted = new HashMap();
        this.m_treesOfInserted = new HashSet();
        this.m_treesLifeCycle = new HashMap();
    }

    void copyFrom(BTreeSnapshot snapshotSrc) throws IOException {
        this.m_treesOfInserted = (HashSet)snapshotSrc.m_treesOfInserted.clone();
        this.m_treesLifeCycle = (HashMap)snapshotSrc.m_treesLifeCycle.clone();
        for (Long treeDBK : snapshotSrc.m_treesOfDeleted.keySet()) {
            SnapshotTree srcTree = (SnapshotTree)snapshotSrc.m_treesOfDeleted.get(treeDBK);
            this.createCopy(treeDBK, srcTree);
        }
    }

    private void createCopy(Long treeDBK, SnapshotTree srcTree) throws IOException {
        SnapshotTree newTree = this.createTree(treeDBK, this.m_treesOfDeleted);
        BTreeIteratorState iterator = new BTreeIteratorState(srcTree.m_snapshotDBK, false);
        while (true) {
            this.m_sShotBtreeManager.advance(this.m_snapshotTransID, iterator, null);
            if (iterator.getAfterLast()) break;
            this.m_sShotBtreeManager.put(this.m_snapshotTransID, newTree.m_snapshotDBK, iterator.getCurrentKey(), iterator.getCurrentValue(), null, false);
        }
    }

    void treeCreatedOrDeleted(Long treeDBK, boolean rollingBack) {
        int countNum;
        Integer count = (Integer)this.m_treesLifeCycle.get(treeDBK);
        if (rollingBack && count == null) {
            throw new Error("Counter mismatch in treeCreatedOrDeleted");
        }
        int n = countNum = count != null ? count : 0;
        if (rollingBack) {
            if (--countNum == 0) {
                this.m_treesLifeCycle.remove(treeDBK);
            } else {
                this.m_treesLifeCycle.put(treeDBK, new Integer(countNum));
            }
        } else {
            this.m_treesLifeCycle.put(treeDBK, new Integer(countNum + 1));
        }
    }

    boolean treeLifeCycleEvent(Long treeDBK) {
        return this.m_treesLifeCycle.get(treeDBK) != null;
    }

    Boolean contains(Long treeDBK, byte[] key, byte[] value) throws IOException {
        boolean inDeleted = this.contains(this.m_treesOfDeleted, treeDBK, key, value);
        boolean inInserted = this.m_treesOfInserted.contains(new BTreeEntryID(treeDBK, key, value));
        if (inDeleted) {
            return Boolean.TRUE;
        }
        if (inInserted) {
            return Boolean.FALSE;
        }
        return null;
    }

    int countDeletedKeyEntries(Long treeDBK, byte[] key) throws IOException {
        SnapshotTree snapShotTree = (SnapshotTree)this.m_treesOfDeleted.get(treeDBK);
        if (snapShotTree == null) {
            return 0;
        }
        return this.m_sShotBtreeManager.countKeyEntries(snapShotTree.m_snapshotDBK, key);
    }

    boolean createdLater(Long treeDBK, byte[] key, byte[] value) throws IOException {
        return this.m_treesOfInserted.contains(new BTreeEntryID(treeDBK, key, value));
    }

    private boolean contains(HashMap treeTable, Long treeDBK, byte[] key, byte[] value) throws IOException {
        SnapshotTree snapShotTree = (SnapshotTree)treeTable.get(treeDBK);
        if (snapShotTree == null) {
            return false;
        }
        return this.m_sShotBtreeManager.contains(this.m_snapshotTransID, snapShotTree.m_snapshotDBK, key, value, null);
    }

    void delete() throws IOException {
        this.deleteTable(this.m_treesOfDeleted);
    }

    private void deleteTable(HashMap treeTable) throws IOException {
        Iterator trees = treeTable.keySet().iterator();
        ArrayList treeList = new ArrayList();
        while (trees.hasNext()) {
            treeList.add(trees.next());
        }
        int sz = treeList.size();
        for (int i = 0; i < sz; ++i) {
            this.deleteTree((Long)treeList.get(i), treeTable);
        }
    }

    BTreeIteratorState.KeyValuePair adjacentInDeleted(BTreeIteratorState iterator, boolean reverse) throws IOException {
        SnapshotTree tree = (SnapshotTree)this.m_treesOfDeleted.get(new Long(iterator.getTreeDbk()));
        if (tree == null) {
            return null;
        }
        BTreeIteratorState.KeyValuePair result = null;
        iterator.save();
        iterator.setDbk(tree.m_snapshotDBK);
        iterator.setReverse(reverse);
        this.m_sShotBtreeManager.advance(this.m_snapshotTransID, iterator, null);
        if (iterator.currentChanged()) {
            result = iterator.getPosition();
        }
        iterator.restore();
        return result;
    }

    BTreeIteratorState.KeyValuePair advanceInDeleted(BTreeIteratorState iterator) throws IOException {
        SnapshotTree tree = (SnapshotTree)this.m_treesOfDeleted.get(new Long(iterator.getTreeDbk()));
        if (tree == null) {
            return null;
        }
        BTreeIteratorState.KeyValuePair result = null;
        iterator.setDbk(tree.m_snapshotDBK);
        iterator.setNotChanged();
        this.m_sShotBtreeManager.advance(this.m_snapshotTransID, iterator, null);
        if (iterator.currentChanged()) {
            result = iterator.getPosition();
        }
        return result;
    }

    boolean containsEntry(Long treeDBK, boolean inDeletionTree, byte[] key, byte[] value) throws IOException {
        if (!inDeletionTree) {
            return this.m_treesOfInserted.contains(new BTreeEntryID(treeDBK, key, value));
        }
        SnapshotTree snapShotTree = (SnapshotTree)this.m_treesOfDeleted.get(treeDBK);
        if (snapShotTree == null) {
            return false;
        }
        return this.m_sShotBtreeManager.contains(this.m_snapshotTransID, snapShotTree.m_snapshotDBK, key, value, null);
    }

    boolean addEntry(Long treeDBK, boolean inDeletionTree, byte[] key, byte[] value) throws IOException {
        if (this.treeLifeCycleEvent(treeDBK)) {
            return false;
        }
        if (!inDeletionTree) {
            return this.m_treesOfInserted.add(new BTreeEntryID(treeDBK, key, value));
        }
        return this.addEntry(treeDBK, this.m_treesOfDeleted, key, value);
    }

    private boolean addEntry(Long treeDBK, HashMap treeTable, byte[] key, byte[] value) throws IOException {
        SnapshotTree snapShotTree = (SnapshotTree)treeTable.get(treeDBK);
        if (snapShotTree != null && this.m_sShotBtreeManager.contains(this.m_snapshotTransID, snapShotTree.m_snapshotDBK, key, value, null)) {
            return false;
        }
        if (snapShotTree == null) {
            snapShotTree = this.createTree(treeDBK, treeTable);
        }
        this.m_sShotBtreeManager.put(this.m_snapshotTransID, snapShotTree.m_snapshotDBK, key, value, null, false);
        snapShotTree.m_count++;
        return true;
    }

    void removeEntry(Long treeDBK, boolean inDeletionTree, byte[] key, byte[] value) throws IOException {
        if (this.treeLifeCycleEvent(treeDBK)) {
            return;
        }
        if (!inDeletionTree) {
            this.m_treesOfInserted.remove(new BTreeEntryID(treeDBK, key, value));
            return;
        }
        SnapshotTree snapShotTree = (SnapshotTree)this.m_treesOfDeleted.get(treeDBK);
        if (snapShotTree == null) {
            return;
        }
        this.m_sShotBtreeManager.remove(this.m_snapshotTransID, snapShotTree.m_snapshotDBK, key, value, null, false);
        snapShotTree.m_count--;
        if (snapShotTree.m_count == 0L) {
            this.deleteTree(treeDBK, this.m_treesOfDeleted);
        }
    }

    private SnapshotTree createTree(Long treeDBK, HashMap treeTable) throws IOException {
        long snapshotID = this.m_sShotBtreeManager.createBTree(this.m_snapshotTransID, false, null);
        SnapshotTree snapshotTree = new SnapshotTree(snapshotID);
        treeTable.put(treeDBK, snapshotTree);
        return snapshotTree;
    }

    private void deleteTree(Long treeDBK, HashMap treeTable) throws IOException {
        SnapshotTree snapShotTree = (SnapshotTree)treeTable.remove(treeDBK);
        if (snapShotTree == null) {
            return;
        }
        this.m_sShotBtreeManager.delete(this.m_snapshotTransID, snapShotTree.m_snapshotDBK, null, false);
    }

    private class SnapshotTree {
        private long m_snapshotDBK;
        private long m_count;

        SnapshotTree(long snapshotDBK) {
            this.m_snapshotDBK = snapshotDBK;
            this.m_count = 0L;
        }
    }
}

