/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class BTreeSplitNote
extends AbstractNote
implements BTreeNoteInterface,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 16;
    byte[] m_scratchBuffer = new byte[8];
    long m_srcPageNum;
    long m_newPageNum;
    byte[] m_srcBuffer;
    int m_srcStart;
    int m_srcLength;
    int m_srcValueOffset;

    BTreeSplitNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_srcPageNum;
    }

    @Override
    public long getPageNum() {
        return this.m_srcPageNum;
    }

    public long getNewPageNum() {
        return this.m_newPageNum;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)16);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_srcPageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_newPageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        int currentLength = 17;
        BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_srcLength);
        writer.write(this.m_scratchBuffer, 0, 2);
        currentLength += 2;
        writer.write(this.m_srcBuffer, this.m_srcStart, this.m_srcLength);
        return currentLength += this.m_srcLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_srcBuffer = buffer;
        int currentOffset = offset;
        this.m_srcPageNum = BitUtil.getLong(buffer, currentOffset);
        this.m_newPageNum = BitUtil.getLong(buffer, currentOffset += 8);
        this.m_srcLength = BitUtil.getShort(buffer, currentOffset += 8);
        this.m_srcValueOffset = currentOffset += 2;
        currentOffset += this.m_srcLength;
    }

    void initNote(long pageNum, byte[] src, int srcStart, int srcLength, long newPageNum) {
        this.m_srcPageNum = pageNum;
        this.m_srcBuffer = src;
        this.m_srcStart = srcStart;
        this.m_srcLength = srcLength;
        this.m_newPageNum = newPageNum;
    }
}

