/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import java.util.HashMap;

final class Cache
extends HashMap {
    private Item m_leastUsed = null;
    private Item m_mostUsed = null;
    private int m_maxSize;
    private int m_usedSize;

    Cache(int maxSize) {
        this.m_maxSize = maxSize;
        this.m_usedSize = 0;
    }

    @Override
    public void clear() {
        super.clear();
        this.m_leastUsed = null;
        this.m_mostUsed = null;
        this.m_usedSize = 0;
    }

    @Override
    Long put(Long key, Object data) {
        Long keyRemovedFromCache = null;
        if (this.containsKey(key)) {
            throw new Error("page " + key + " already in cache");
        }
        if (this.m_maxSize == this.m_usedSize) {
            keyRemovedFromCache = this.m_leastUsed.key;
            this.remove(this.m_leastUsed.key);
        }
        Item newItem = new Item(key, data);
        super.put(key, newItem);
        ++this.m_usedSize;
        this.putAtEnd(newItem);
        return keyRemovedFromCache;
    }

    Object get(Long key) {
        Item item = (Item)super.get(key);
        if (item == null) {
            return null;
        }
        if (item != this.m_mostUsed) {
            this.removeFromChain(item);
            this.putAtEnd(item);
        }
        return item.data;
    }

    void remove(Long key) {
        Item item = (Item)super.remove(key);
        if (item == null) {
            return;
        }
        this.removeFromChain(item);
        --this.m_usedSize;
    }

    private void removeFromChain(Item item) {
        Item prev = item.prevItem;
        Item next = item.nextItem;
        if (prev != null) {
            prev.nextItem = next;
        }
        if (next != null) {
            next.prevItem = prev;
        }
        if (this.m_leastUsed == item) {
            this.m_leastUsed = next;
        }
        if (this.m_mostUsed == item) {
            this.m_mostUsed = prev;
        }
        item.prevItem = null;
        item.nextItem = null;
    }

    void adjustSize(int newSize) {
        this.m_maxSize = newSize < this.m_usedSize ? this.m_usedSize : newSize;
    }

    private void putAtEnd(Item item) {
        if (this.m_leastUsed == null) {
            this.m_leastUsed = this.m_mostUsed = item;
            return;
        }
        this.m_mostUsed.nextItem = item;
        item.prevItem = this.m_mostUsed;
        this.m_mostUsed = item;
    }

    private class Item {
        private Long key;
        private Object data;
        private Item nextItem;
        private Item prevItem;

        Item(Long key, Object data) {
            this.key = key;
            this.data = data;
            this.prevItem = null;
            this.nextItem = null;
        }
    }
}

