/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AsyncFile;
import com.sonicsw.mtstorage.impl.Cache;
import com.sonicsw.mtstorage.impl.DataPage;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.MasterPage;
import com.sonicsw.mtstorage.impl.Page;
import com.sonicsw.mtstorage.impl.PageAllocationNote;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

final class CachedPagesFile {
    private static final int NO_CACHE = -2;
    private static final int DIRTY_LIST_CACHE = -1;
    private static final Integer DIRTY_LIST_CACHE_NUM = new Integer(-1);
    private AsyncFile m_asyncFile;
    private Cache[] m_typedCaches;
    private HashMap m_cacheMapper;
    private HashMap m_dirtyPages;
    private MasterPage m_masterPage;
    private boolean m_masterPageIsDirty;
    private Logger m_logger;
    private long m_allocatedPagesCount;
    private boolean m_doSync;
    private int m_writeDirtyThreshold;
    private PageAllocationNote m_pageAllocateNote;
    private long m_dataPagesWrite_statistics;
    private long m_dataPagesRead_statistics;
    private long m_masterPageWrite_statistics;
    private long m_masterPageRead_statistics;
    private long m_dataFileSync_statistics;

    CachedPagesFile() {
    }

    boolean open(String fileName, Logger logger, int[] cacheCapacities, int queueSizeLimit, boolean createFile, boolean doSync, int writeDirtyThreshold) throws IOException {
        this.m_logger = logger;
        this.m_doSync = doSync;
        this.m_masterPageIsDirty = false;
        this.m_dirtyPages = new HashMap();
        this.m_cacheMapper = new HashMap();
        this.m_writeDirtyThreshold = writeDirtyThreshold;
        this.m_pageAllocateNote = new PageAllocationNote();
        this.m_dataPagesWrite_statistics = 0L;
        this.m_dataPagesRead_statistics = 0L;
        this.m_masterPageWrite_statistics = 0L;
        this.m_masterPageRead_statistics = 0L;
        this.m_dataFileSync_statistics = 0L;
        this.m_asyncFile = new AsyncFile(fileName, createFile, queueSizeLimit, doSync);
        this.m_allocatedPagesCount = this.m_asyncFile.getAllocatedCount();
        this.m_typedCaches = new Cache[cacheCapacities.length];
        for (int i = 0; i < cacheCapacities.length; ++i) {
            this.m_typedCaches[i] = new Cache(cacheCapacities[i]);
        }
        return this.m_asyncFile.isNew();
    }

    void startAsyncMode(Integer asyncFrequency) {
        this.m_asyncFile.startAsyncMode(asyncFrequency);
    }

    void clearCache() {
        if (!this.m_dirtyPages.isEmpty()) {
            throw new Error("clearCache was called with m_dirtyPages.size() > 0");
        }
        for (int i = 0; i < this.m_typedCaches.length; ++i) {
            this.m_typedCaches[i].clear();
        }
        this.m_cacheMapper = new HashMap();
    }

    void getMetrics(Properties props, String dbName) {
        props.setProperty(dbName + ".dataPagesWrite_statistics", new Long(this.m_dataPagesWrite_statistics).toString());
        props.setProperty(dbName + ".dataPagesRead_statistics", new Long(this.m_dataPagesRead_statistics).toString());
        props.setProperty(dbName + ".masterPageWrite_statistics", new Long(this.m_masterPageWrite_statistics).toString());
        props.setProperty(dbName + ".masterPageRead_statistics", new Long(this.m_masterPageRead_statistics).toString());
        props.setProperty(dbName + ".dataFileSync_statistics", new Long(this.m_dataFileSync_statistics).toString());
    }

    synchronized Page get(boolean forUpdate, long pageNumber) throws IOException {
        Long key = new Long(pageNumber);
        if (pageNumber == 0L) {
            if (this.m_masterPage == null) {
                this.m_masterPage = this.readMasterPage();
            }
            if (forUpdate) {
                this.m_masterPageIsDirty = true;
            }
            return this.m_masterPage;
        }
        Integer cacheNumber = (Integer)this.m_cacheMapper.get(key);
        if (cacheNumber == null) {
            return this.readDataPage(pageNumber, forUpdate);
        }
        if (cacheNumber == -1) {
            return (Page)this.m_dirtyPages.get(key);
        }
        int cacheNum = cacheNumber;
        Page page = (Page)this.m_typedCaches[cacheNum].get(key);
        if (page == null) {
            throw new Error("The page was not found in the cache.");
        }
        if (forUpdate) {
            this.moveToDirtyList(cacheNum, page);
        }
        return page;
    }

    private MasterPage readMasterPage() throws IOException {
        if (this.m_allocatedPagesCount == 0L) {
            return null;
        }
        MasterPage page = new MasterPage();
        this.m_asyncFile.read(page);
        ++this.m_masterPageRead_statistics;
        return page;
    }

    private DataPage readDataPage(long pageNumber, boolean forUpdate) throws IOException {
        if (pageNumber >= this.m_allocatedPagesCount) {
            return null;
        }
        DataPage page = new DataPage();
        page.setPageNum(pageNumber);
        this.m_asyncFile.read(page);
        ++this.m_dataPagesRead_statistics;
        page.createBuffer(false, this.m_logger);
        if (forUpdate) {
            this.moveToDirtyList(-2, page);
        } else {
            this.moveToCache(-2, page);
        }
        if (page.needsReorg()) {
            page.doReorg();
        }
        return page;
    }

    void writePagesIfNeeded(boolean forceLog) throws IOException {
        if (this.m_dirtyPages.size() >= this.m_writeDirtyThreshold) {
            this.writePages(forceLog);
        }
    }

    private void moveToDirtyList(int fromCache, Page page) throws IOException {
        Long key = page.getPageKey();
        this.m_dirtyPages.put(key, page);
        if (fromCache != -2) {
            this.m_typedCaches[fromCache].remove(key);
        }
        this.m_cacheMapper.put(key, DIRTY_LIST_CACHE_NUM);
    }

    private void moveToCache(int fromCache, Page page) {
        Long key = page.getPageKey();
        byte pageType = page.getPageType();
        if (fromCache == -1) {
            this.m_dirtyPages.remove(key);
        } else if (fromCache != -2) {
            this.m_typedCaches[fromCache].remove(key);
        }
        Long swappedOutOfCacheKey = this.m_typedCaches[pageType].put(key, page);
        if (swappedOutOfCacheKey != null) {
            this.m_cacheMapper.remove(swappedOutOfCacheKey);
        }
        this.m_cacheMapper.put(key, new Integer(pageType));
    }

    void deallocate(long lowestNumAllocated, long highestNumAllocated) throws IOException {
        this.m_asyncFile.deallocate(lowestNumAllocated);
        this.m_allocatedPagesCount = lowestNumAllocated;
        this.removePageFromMemory(lowestNumAllocated, highestNumAllocated);
    }

    private void removePageFromMemory(long lowestNumAllocated, long highestNumAllocated) {
        for (long pageNum = lowestNumAllocated; pageNum <= highestNumAllocated; ++pageNum) {
            Long key = new Long(pageNum);
            Integer cacheNumber = (Integer)this.m_cacheMapper.get(key);
            this.m_cacheMapper.remove(key);
            if (cacheNumber == null) continue;
            if (cacheNumber == -1) {
                this.m_dirtyPages.remove(key);
                continue;
            }
            this.m_typedCaches[cacheNumber].remove(key);
        }
    }

    DataPage allocate() throws IOException {
        this.m_pageAllocateNote.initNote(this.m_allocatedPagesCount);
        this.m_logger.writeNote(this.m_pageAllocateNote);
        DataPage page = new DataPage();
        page.setPageNum(this.m_allocatedPagesCount++);
        page.setPageType((byte)4);
        page.createBuffer(true, this.m_logger);
        this.moveToDirtyList(-2, page);
        return page;
    }

    void redoAllocate(long pageNum) throws IOException {
        if (pageNum < this.m_allocatedPagesCount) {
            return;
        }
        if (pageNum > this.m_allocatedPagesCount) {
            throw new IOException("redoAllocate out of sequence.");
        }
        DataPage page = new DataPage();
        page.setPageNum(this.m_allocatedPagesCount++);
        page.setPageType((byte)4);
        page.createBuffer(true, this.m_logger);
        this.moveToDirtyList(-2, page);
    }

    long getAllocatedCount() {
        return this.m_allocatedPagesCount;
    }

    MasterPage allocateMasterPage() {
        if (this.m_allocatedPagesCount > 0L) {
            throw new Error();
        }
        this.m_masterPage = new MasterPage();
        this.m_masterPageIsDirty = true;
        ++this.m_allocatedPagesCount;
        return this.m_masterPage;
    }

    void writePages(boolean forceLog) throws IOException {
        int i;
        int numDirtypages = this.m_dirtyPages.size();
        if (numDirtypages == 0) {
            return;
        }
        if (forceLog) {
            this.m_logger.forceToDisk(false, false);
        }
        Object[] sortedPages = new Comparable[numDirtypages];
        Iterator iter = this.m_dirtyPages.values().iterator();
        for (i = 0; i < numDirtypages; ++i) {
            sortedPages[i] = (Comparable)iter.next();
        }
        Arrays.sort(sortedPages);
        for (i = 0; i < numDirtypages; ++i) {
            this.writeDataPage((Page)sortedPages[i]);
        }
    }

    private synchronized void writeDataPage(Page page) throws IOException {
        this.m_asyncFile.write(page);
        ++this.m_dataPagesWrite_statistics;
        this.moveToCache(-1, page);
    }

    synchronized void writeMaster() throws IOException {
        if (!this.m_masterPageIsDirty) {
            return;
        }
        this.m_asyncFile.write(this.m_masterPage);
        ++this.m_masterPageWrite_statistics;
        this.m_masterPageIsDirty = false;
    }

    synchronized void syncBuffers() throws IOException {
        ++this.m_dataFileSync_statistics;
        this.m_asyncFile.sync();
    }

    long getFileSize() throws IOException {
        return this.m_asyncFile.getFileSize();
    }

    void close() throws IOException {
        this.m_asyncFile.close();
    }
}

