/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractContentPage;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.ObjectsBuffer;
import com.sonicsw.mtstorage.impl.Page;

class DataPage
extends AbstractContentPage {
    private static final short FULL_THRESHHOLD_FREE_SPACE = (short)((double)Page.PAGE_LENGTH * 0.25);
    private static final short MAX_FREE_SPACE = (short)(Page.PAGE_LENGTH - FULL_THRESHHOLD_FREE_SPACE);

    DataPage() {
    }

    @Override
    void createBuffer(boolean init, Logger logger) {
        this.m_contentBuffer = new ObjectsBuffer(this.m_buffer, this, 27, CONTENT_BUFFER_CAPACITY, logger, this.getPageType(), init);
    }

    @Override
    boolean isFree() {
        return !((ObjectsBuffer)this.m_contentBuffer).hasUsedSlots();
    }

    @Override
    boolean isFull(boolean fromDelete, int reuseThreshold) {
        boolean isFull;
        boolean bl = isFull = !((ObjectsBuffer)this.m_contentBuffer).hasFreeSlots() || ((ObjectsBuffer)this.m_contentBuffer).getFreeSpace() < FULL_THRESHHOLD_FREE_SPACE;
        if (isFull) {
            return true;
        }
        if (!fromDelete || reuseThreshold == 0) {
            return false;
        }
        float freeSpaceRatio = (float)((ObjectsBuffer)this.m_contentBuffer).getFreeSpace() / (float)MAX_FREE_SPACE;
        return !this.isFree() && !(freeSpaceRatio * 100.0f >= (float)reuseThreshold);
    }

    static class AvailablePage {
        DataPage m_page;
        byte m_availableSlot;

        AvailablePage(DataPage page) {
            this.m_page = page;
            this.m_availableSlot = (byte)-1;
        }

        AvailablePage(DataPage page, byte availableSlot) {
            this.m_page = page;
            this.m_availableSlot = availableSlot;
        }
    }
}

