/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

final class LogWriteGroup {
    private HashMap m_requestorList = new HashMap();
    private long m_waitPeriod;
    private static long[] TEST_THREAD_FREQUENCY = new long[]{70L, 8L, 9L, 3L, 11L, 5L, 88L, 33L, 16L, 5L};

    public static void main(String[] args) throws Exception {
        LogWriteGroup writeGrp = new LogWriteGroup(50L);
        for (int i = 0; i < 10; ++i) {
            new TestRequestor("a" + i, writeGrp, TEST_THREAD_FREQUENCY[i]).start();
        }
    }

    LogWriteGroup(long waitPeriod) {
        this.m_waitPeriod = waitPeriod;
    }

    synchronized HashSet postRequest() throws InterruptedException {
        Boolean myListStatus;
        Thread me = Thread.currentThread();
        this.m_requestorList.put(me, Boolean.FALSE);
        long startWaitTime = System.currentTimeMillis();
        long timeLeftToWait = this.m_waitPeriod;
        while (timeLeftToWait > 0L) {
            this.wait(timeLeftToWait);
            myListStatus = (Boolean)this.m_requestorList.get(me);
            if (myListStatus == null || myListStatus.booleanValue()) break;
            timeLeftToWait = this.m_waitPeriod - (System.currentTimeMillis() - startWaitTime);
        }
        if ((myListStatus = (Boolean)this.m_requestorList.get(me)) != null) {
            if (myListStatus.booleanValue()) {
                while (this.m_requestorList.containsKey(me)) {
                    this.wait();
                }
                return null;
            }
            return this.getCommitGroup();
        }
        return null;
    }

    private HashSet getCommitGroup() {
        Iterator<Object> threadIter = this.m_requestorList.keySet().iterator();
        HashSet threadSet = new HashSet();
        while (threadIter.hasNext()) {
            Object thread = threadIter.next();
            Boolean threadStatus = (Boolean)this.m_requestorList.get(thread);
            if (threadStatus.booleanValue()) continue;
            threadSet.add(thread);
        }
        threadIter = threadSet.iterator();
        while (threadIter.hasNext()) {
            this.m_requestorList.put(threadIter.next(), Boolean.TRUE);
        }
        return threadSet;
    }

    synchronized void notifyAndRemoveFromGroup(HashSet threadSet) {
        Iterator threadIter = threadSet.iterator();
        while (threadIter.hasNext()) {
            this.m_requestorList.remove(threadIter.next());
        }
        this.notifyAll();
    }

    static class TestRequestor
    extends Thread {
        private String m_name;
        private LogWriteGroup m_logWriteGroup;
        private long m_sleepTime;
        private static long startWaitTime = System.currentTimeMillis();
        private static int m_total = 0;
        private static Integer m_lock = new Integer(0);

        TestRequestor(String name, LogWriteGroup logWriteGroup, long sleepTime) {
            super(name);
            this.m_name = name;
            this.m_logWriteGroup = logWriteGroup;
            this.m_sleepTime = sleepTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (int i = 0; i < 100; ++i) {
                    Thread.sleep(this.m_sleepTime);
                    HashSet set = this.m_logWriteGroup.postRequest();
                    if (set == null) continue;
                    Integer n = m_lock;
                    synchronized (n) {
                        Thread.sleep(50L);
                        System.out.println(this.m_name + " Wrote to log for set size " + set.size() + " total " + (m_total += set.size()));
                        if (m_total == 1000) {
                            System.out.println("total time " + (System.currentTimeMillis() - startWaitTime) / 1000L);
                            System.exit(0);
                        }
                    }
                    this.m_logWriteGroup.notifyAndRemoveFromGroup(set);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

