/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Constants;

final class ObjectFragment {
    private static final short FRAGMENT_SIZE_OFFSET = 0;
    private static final short FLAGS_OFFSET = 2;
    private static final short CLASS_TYPE_OFFSET = 3;
    private static final short NEXT_FRAGMENT_OFFSET = 7;
    private static final short TOTAL_OBJECT_SIZE_OFFSET = 15;
    private static final byte LEAD_FLAG = 1;
    private static final byte LAST_FLAG = 2;
    private static final byte NOT_INITIALIZED_FLAG = 4;
    static final short MAX_HEADER = 23;
    private byte[] m_buffer;
    private short m_offset;
    private short m_headerLength;
    private short m_fragmentLength;
    private boolean m_lead;
    private boolean m_last;
    private boolean m_notInitialized;

    ObjectFragment(byte[] buffer, short offset) {
        this.m_buffer = buffer;
        this.m_offset = offset;
        byte flags = this.m_buffer[this.m_offset + 2];
        this.m_lead = (flags & 1) != 0;
        this.m_last = (flags & 2) != 0;
        this.m_notInitialized = (flags & 4) != 0;
        this.m_headerLength = ObjectFragment.calcHeaderLength(this.m_lead, this.m_last);
        this.m_fragmentLength = (short)(this.getTotalFragmentLength() - this.m_headerLength);
    }

    static short calcHeaderLength(boolean leadFragment, boolean lastFragment) {
        if (leadFragment) {
            return 23;
        }
        if (lastFragment) {
            return 3;
        }
        return 15;
    }

    static void createHeader(byte[] buffer, short offset, short totalFragmentLength, int classType, boolean leadFragment, boolean lastFragment, int totalObjectLenth) {
        byte flags;
        BitUtil.putShort(buffer, offset, totalFragmentLength);
        buffer[offset + 2] = flags = (byte)((leadFragment ? 1 : 0) + (lastFragment ? 2 : 0) + 4);
        if (leadFragment) {
            BitUtil.putInt(buffer, offset + 3, classType);
        }
        if (leadFragment && !lastFragment) {
            BitUtil.putLong(buffer, offset + 15, totalObjectLenth);
        }
    }

    void setInitialized() {
        this.m_buffer[this.m_offset + 2] = (byte)(this.m_buffer[this.m_offset + 2] & 0xFFFFFFFB);
    }

    boolean isLeadFragment() {
        return this.m_lead;
    }

    boolean notInitialized() {
        return this.m_notInitialized;
    }

    boolean isLastFragment() {
        return this.m_last;
    }

    short getTotalFragmentLength() {
        return BitUtil.getShort(this.m_buffer, this.m_offset);
    }

    short getFragmentLength() {
        return this.m_fragmentLength;
    }

    void setTotalFragmentLength(short totalLength) {
        BitUtil.putShort(this.m_buffer, this.m_offset, totalLength);
        this.m_fragmentLength = (short)(totalLength - this.m_headerLength);
    }

    short getFragmentHeaderLength() {
        return this.m_headerLength;
    }

    long getObjectLength() {
        if (!this.m_lead) {
            throw new Error("Not Lead");
        }
        if (!this.m_last) {
            return BitUtil.getLong(this.m_buffer, this.m_offset + 15);
        }
        return this.m_fragmentLength;
    }

    long getNextFragmentDbkey() {
        if (this.m_last) {
            throw new Error("Last fragment");
        }
        return BitUtil.getLong(this.m_buffer, this.m_offset + 7);
    }

    void setNextFragmentDbkey(long nextDbkey) {
        if (this.m_last) {
            throw new Error("Last fragment");
        }
        BitUtil.putLong(this.m_buffer, this.m_offset + 7, nextDbkey);
    }

    int getClassType() {
        if (!this.m_lead) {
            throw new Error("Not lead fragment");
        }
        return BitUtil.getInt(this.m_buffer, this.m_offset + 3);
    }

    void updateData(byte[] src, int offset) {
        System.arraycopy(src, offset, this.m_buffer, this.m_offset + this.m_headerLength, this.m_fragmentLength);
    }

    int getPayloadOffset() {
        return this.m_offset + this.m_headerLength;
    }

    int getData(byte[] destination, int offset) {
        int roomInDestination = destination.length - offset;
        int readCount = Constants.MIN(roomInDestination, this.m_fragmentLength);
        if (readCount > 0) {
            System.arraycopy(this.m_buffer, this.m_offset + this.m_headerLength, destination, offset, readCount);
        }
        return readCount;
    }
}

