/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractContentBuffer;
import com.sonicsw.mtstorage.impl.BitSetUtil;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.CreateNote;
import com.sonicsw.mtstorage.impl.DataPage;
import com.sonicsw.mtstorage.impl.Dbkey;
import com.sonicsw.mtstorage.impl.DeleteBlobNote;
import com.sonicsw.mtstorage.impl.DeleteNote;
import com.sonicsw.mtstorage.impl.IContentBufferNote;
import com.sonicsw.mtstorage.impl.IObjectsBufferNote;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.NextFragmentNote;
import com.sonicsw.mtstorage.impl.ObjectFragment;
import com.sonicsw.mtstorage.impl.RecentTransactionNote;
import com.sonicsw.mtstorage.impl.ReplaceNote;
import com.sonicsw.mtstorage.impl.UndoRedoRedundancy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

final class ObjectsBuffer
extends AbstractContentBuffer {
    static final byte NO_LOGGING = 0;
    static final byte NO_UNDO_DATA_LOGGING = 1;
    static final byte FULL_LOGGING = 2;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final boolean STORE_DELETED_DATA_IN_NOTE = true;
    private static final short NUM_SLOTS = 127;
    private static final boolean CHECK_INTEGRITY = false;
    private static final boolean DEBUG = false;
    private static final byte NEEDS_REORG_FLAG = 1;
    private static final short FLAG_OFFSET = 0;
    private static final short TRANSACTION_NUM_OFFSET = 1;
    private static final short SLOTS_OFFSET = 9;
    private static final short SLOTS_PENDING_DELETE_OFFSET = 25;
    private static final short OBJECT_POINTERS_OFFSET = 41;
    private static final short OBJECTS_OFFSET = 295;
    private byte[] m_buffer;
    private short m_total_available;
    private short m_offset_start;
    private short m_flags_offset;
    private short m_transaction_num_offset;
    private short m_slots_offset;
    private short m_slots_pending_delete_offset;
    private short m_objects_pointers_offset;
    private short m_objects_offset;
    private byte m_pageType;
    private boolean m_blobObjects;
    private long m_transactionNum;
    private DataPage m_page;
    private long m_pageNum;
    private Logger m_logger;
    private BitSetUtil m_slots;
    private BitSetUtil m_slots_pending_delete;
    private short[] m_objectOffsets;
    private ArrayList m_sortedOffsets;
    private short m_spaceUsed;
    private transient Object m_cachedState;
    RecentTransactionNote m_transactionNote;
    DeleteNote m_deleteNote;
    DeleteBlobNote m_deleteBlobNote;
    CreateNote m_createNote;
    ReplaceNote m_replaceNote;
    NextFragmentNote m_nextFragmentNote;

    private void calcOffsets() {
        this.m_flags_offset = (short)(this.m_offset_start + 0);
        this.m_transaction_num_offset = (short)(this.m_offset_start + 1);
        this.m_slots_offset = (short)(this.m_offset_start + 9);
        this.m_slots_pending_delete_offset = (short)(this.m_offset_start + 25);
        this.m_objects_pointers_offset = (short)(this.m_offset_start + 41);
        this.m_objects_offset = (short)(this.m_offset_start + 295);
    }

    private void storeSlotBits(long long0, long long1) {
        BitUtil.putLong(this.m_buffer, this.m_slots_offset, long0);
        BitUtil.putLong(this.m_buffer, this.m_slots_offset + 8, long1);
    }

    private void storeSlotPendingDeleteBits(long long0, long long1) {
        BitUtil.putLong(this.m_buffer, this.m_slots_pending_delete_offset, long0);
        BitUtil.putLong(this.m_buffer, this.m_slots_pending_delete_offset + 8, long1);
    }

    private void storeSlotBits() {
        long[] longArray = this.m_slots.getBitArray();
        this.storeSlotBits(longArray[0], longArray[1]);
    }

    private void storeSlotPendingDeleteBits() {
        long[] longArray = this.m_slots_pending_delete.getBitArray();
        this.storeSlotPendingDeleteBits(longArray[0], longArray[1]);
    }

    void retrieveSlotBits() {
        long[] slots = new long[]{BitUtil.getLong(this.m_buffer, this.m_slots_offset), BitUtil.getLong(this.m_buffer, this.m_slots_offset + 8)};
        this.m_slots = new BitSetUtil(slots);
    }

    void retrieveSlotPendingDeleteBits() {
        long[] slots = new long[]{BitUtil.getLong(this.m_buffer, this.m_slots_pending_delete_offset), BitUtil.getLong(this.m_buffer, this.m_slots_pending_delete_offset + 8)};
        this.m_slots_pending_delete = new BitSetUtil(slots);
    }

    static BitSetUtil createEmptySlots() {
        return new BitSetUtil(new long[2]);
    }

    private void setNeedsReorg(boolean needsReorg) {
        if (needsReorg) {
            short s = this.m_flags_offset;
            this.m_buffer[s] = (byte)(this.m_buffer[s] | 1);
        } else {
            this.m_buffer[this.m_flags_offset] = (byte)(this.m_buffer[this.m_flags_offset] & 0xFFFFFFFE);
        }
    }

    @Override
    boolean canReorg(long currentTransaction) {
        return this.m_transactionNum < currentTransaction;
    }

    @Override
    boolean getNeedsReorg() {
        return (this.m_buffer[this.m_flags_offset] & 1) != 0;
    }

    private void initValues() {
        this.m_buffer[this.m_flags_offset] = 0;
        BitUtil.putLong(this.m_buffer, this.m_transaction_num_offset, 0L);
        this.storeSlotBits(0L, 0L);
        this.storeSlotPendingDeleteBits(0L, 0L);
        for (int i = 0; i < 127; ++i) {
            BitUtil.putShort(this.m_buffer, this.m_objects_pointers_offset + 2 * i, (short)0);
        }
    }

    @Override
    void doReorg() throws IOException {
        int numUsedSlots = this.getNumUsedSlots(true);
        for (int i = numUsedSlots - 1; i >= 0; --i) {
            this.delete(((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_slotNum, false, true);
        }
        this.setNeedsReorg(false);
    }

    private short calculateSpaceUsed() {
        int numUsedSlots = this.getNumUsedSlots(true);
        short spaceUsed = 0;
        for (int i = 0; i < numUsedSlots; ++i) {
            byte slot = ((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_slotNum;
            if (this.m_slots_pending_delete.get(slot)) continue;
            spaceUsed = (short)(spaceUsed + this.getObjectFragment(slot).getTotalFragmentLength());
        }
        return spaceUsed;
    }

    private String toStringDEBUG(short fragmentSize, short lastSlot, short lastFragLength, short newFragmentStart) {
        String stateString = "ObjectsBuffer state START: " + LINE_SEPARATOR;
        stateString = stateString + "m_pageNum " + this.m_pageNum + LINE_SEPARATOR;
        stateString = stateString + "new fragmentSize " + fragmentSize + LINE_SEPARATOR;
        stateString = stateString + "getNeedsReorg() " + this.getNeedsReorg() + LINE_SEPARATOR;
        stateString = stateString + "m_slots_pending_delete.cardinality() " + this.m_slots_pending_delete.cardinality() + LINE_SEPARATOR;
        stateString = stateString + "numUsedSlots " + this.getNumUsedSlots(true) + LINE_SEPARATOR;
        stateString = stateString + "m_sortedOffsets.size() " + this.m_sortedOffsets.size() + LINE_SEPARATOR;
        stateString = stateString + "m_spaceUsed " + this.m_spaceUsed + LINE_SEPARATOR;
        stateString = stateString + "lastSlot: " + lastSlot + LINE_SEPARATOR;
        stateString = stateString + "lastFragLength: " + lastFragLength + LINE_SEPARATOR;
        stateString = stateString + "newFragmentStart: " + newFragmentStart + LINE_SEPARATOR;
        stateString = stateString + "ObjectsBuffer state END." + LINE_SEPARATOR;
        return stateString;
    }

    private String getThrowableStackDEBUG(Throwable t) {
        ByteArrayOutputStream bst = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bst);
        t.printStackTrace(pw);
        pw.close();
        return bst.toString();
    }

    private void checkIntegrityDEBUG() {
        int i;
        if (!this.getNeedsReorg() && this.m_slots_pending_delete.cardinality() > 0) {
            throw new Error("getNeedsReorg() is false but there are pending deletes");
        }
        int numUsedSlots = this.getNumUsedSlots(true);
        if (numUsedSlots != this.m_sortedOffsets.size()) {
            throw new Error("checkIntegrity ");
        }
        short[] objectLengths = new short[numUsedSlots];
        for (i = 0; i < numUsedSlots; ++i) {
            byte slot = ((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_slotNum;
            if (this.m_objectOffsets[slot] != ((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_offset) {
                throw new Error("checkIntegrity ");
            }
            ObjectFragment fragment = new ObjectFragment(this.m_buffer, ((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_offset);
            objectLengths[i] = fragment.getTotalFragmentLength();
        }
        for (i = 0; i < numUsedSlots; ++i) {
            short prevLength;
            short prevOffset;
            short thisOffset;
            if (!(i == 0 ? ((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_offset != this.m_objects_offset : (thisOffset = ((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_offset) != (prevOffset = ((ObjectOffset)this.m_sortedOffsets.get((int)(i - 1))).m_offset) + (prevLength = objectLengths[i - 1]))) continue;
            throw new Error("checkIntegrity ");
        }
        this.checkMemoryIntegrityDEBUG();
    }

    private void checkMemoryIntegrityDEBUG() {
        int i;
        long transactionNum = BitUtil.getLong(this.m_buffer, this.m_transaction_num_offset);
        long[] slots = new long[]{BitUtil.getLong(this.m_buffer, this.m_slots_offset), BitUtil.getLong(this.m_buffer, this.m_slots_offset + 8)};
        BitSetUtil slotsBitSet = new BitSetUtil(slots);
        short[] objectOffsets = new short[127];
        for (int i2 = 0; i2 < 127; ++i2) {
            objectOffsets[i2] = BitUtil.getShort(this.m_buffer, this.m_objects_pointers_offset + 2 * i2);
        }
        Object[] sortedOffsetsA = new ObjectOffset[slotsBitSet.cardinality()];
        int sortedIndex = 0;
        for (int i3 = 0; i3 < 127; ++i3) {
            if (!slotsBitSet.get(i3)) continue;
            sortedOffsetsA[sortedIndex++] = new ObjectOffset((byte)i3, objectOffsets[i3]);
        }
        Arrays.sort(sortedOffsetsA);
        ArrayList<Object> sortedOffsets = new ArrayList<Object>(sortedOffsetsA.length);
        for (i = 0; i < sortedOffsetsA.length; ++i) {
            sortedOffsets.add(sortedOffsetsA[i]);
        }
        if (this.getNumUsedSlots(true) != slotsBitSet.cardinality()) {
            throw new Error("checkIntegrity ");
        }
        if (transactionNum != this.m_transactionNum) {
            throw new Error("checkIntegrity ");
        }
        for (i = 0; i < 127; ++i) {
            if (objectOffsets[i] == this.m_objectOffsets[i]) continue;
            throw new Error("checkIntegrity ");
        }
        if (this.m_sortedOffsets.size() != sortedOffsets.size()) {
            throw new Error("checkIntegrity ");
        }
        int numUsedSlots = this.getNumUsedSlots(true);
        for (int i4 = 0; i4 < numUsedSlots; ++i4) {
            if (((ObjectOffset)this.m_sortedOffsets.get((int)i4)).m_offset == ((ObjectOffset)sortedOffsets.get((int)i4)).m_offset) continue;
            throw new Error("checkIntegrity ");
        }
    }

    private void updateMemory() {
        int i;
        this.m_transactionNum = BitUtil.getLong(this.m_buffer, this.m_transaction_num_offset);
        this.retrieveSlotBits();
        this.retrieveSlotPendingDeleteBits();
        this.m_objectOffsets = new short[127];
        for (int i2 = 0; i2 < 127; ++i2) {
            this.m_objectOffsets[i2] = BitUtil.getShort(this.m_buffer, this.m_objects_pointers_offset + 2 * i2);
        }
        Object[] sortedOffsets = new ObjectOffset[this.getNumUsedSlots(true)];
        int sortedIndex = 0;
        for (i = 0; i < 127; ++i) {
            if (!this.m_slots.get(i)) continue;
            sortedOffsets[sortedIndex++] = new ObjectOffset((byte)i, this.m_objectOffsets[i]);
        }
        Arrays.sort(sortedOffsets);
        this.m_sortedOffsets = new ArrayList(sortedOffsets.length);
        for (i = 0; i < sortedOffsets.length; ++i) {
            this.m_sortedOffsets.add(sortedOffsets[i]);
        }
        this.m_spaceUsed = this.calculateSpaceUsed();
    }

    private byte shiftFollowers(byte modifiedSlot, short delta) {
        byte slotLocation = ObjectOffset.findSlot(this.m_sortedOffsets, modifiedSlot);
        if (slotLocation + 1 >= this.m_sortedOffsets.size()) {
            return slotLocation;
        }
        short shiftPoint = ((ObjectOffset)this.m_sortedOffsets.get((int)(slotLocation + 1))).m_offset;
        short shiftTo = (short)(shiftPoint + delta);
        byte lastSlot = ((ObjectOffset)this.m_sortedOffsets.get((int)(this.m_sortedOffsets.size() - 1))).m_slotNum;
        short lastFragmentStart = this.m_objectOffsets[lastSlot];
        ObjectFragment lastFragment = new ObjectFragment(this.m_buffer, lastFragmentStart);
        short lastFragmentEnd = (short)(lastFragmentStart + lastFragment.getTotalFragmentLength() - 1);
        short totalShiftLength = (short)(lastFragmentEnd - shiftPoint + 1);
        System.arraycopy(this.m_buffer, shiftPoint, this.m_buffer, shiftTo, totalShiftLength);
        for (int i = slotLocation + 1; i < this.m_sortedOffsets.size(); ++i) {
            short newOffset;
            byte slotNum = ((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_slotNum;
            this.m_objectOffsets[slotNum] = newOffset = (short)(((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_offset + delta);
            ((ObjectOffset)this.m_sortedOffsets.get((int)i)).m_offset = newOffset;
            BitUtil.putShort(this.m_buffer, this.m_objects_pointers_offset + 2 * slotNum, newOffset);
        }
        return slotLocation;
    }

    ObjectsBuffer cloneDEBUG() {
        byte[] newBuf = new byte[this.m_buffer.length];
        System.arraycopy(this.m_buffer, 0, newBuf, 0, this.m_buffer.length);
        return new ObjectsBuffer(newBuf, this.m_page, this.m_offset_start, this.m_total_available, null, this.m_pageType, false);
    }

    @Override
    void setPageType(byte pageType) {
        this.m_pageType = pageType;
        this.m_blobObjects = this.m_pageType == 1;
    }

    ObjectsBuffer(byte[] buffer, DataPage page, short offset, short length, Logger logger, byte pageType, boolean init) {
        this.m_buffer = buffer;
        this.m_page = page;
        this.m_pageNum = page.getPageNum();
        this.m_total_available = length;
        this.m_offset_start = offset;
        this.m_logger = logger;
        this.m_pageType = pageType;
        this.m_blobObjects = this.m_pageType == 1;
        this.m_transactionNote = new RecentTransactionNote();
        this.m_deleteNote = new DeleteNote();
        this.m_deleteBlobNote = new DeleteBlobNote();
        this.m_createNote = new CreateNote();
        this.m_replaceNote = new ReplaceNote();
        this.m_nextFragmentNote = new NextFragmentNote();
        this.calcOffsets();
        if (init) {
            this.initValues();
        }
        this.updateMemory();
    }

    @Override
    void setTransactionNum(long newTransNum) throws IOException {
        this.setTransactionNum(newTransNum, true);
    }

    @Override
    void setTransactionNum(long newTransNum, boolean doLogging) throws IOException {
        if (newTransNum != this.m_transactionNum) {
            if (doLogging) {
                this.m_transactionNote.initNote(this.m_pageNum, this.m_transactionNum, newTransNum);
                long noteID = this.m_logger.writeNote(this.m_transactionNote);
                this.m_page.setNoteID(noteID);
            }
            this.m_transactionNum = newTransNum;
            BitUtil.putLong(this.m_buffer, this.m_transaction_num_offset, newTransNum);
        }
    }

    ObjectFragment getObjectFragment(byte slotNum) {
        if (!this.m_slots.get(slotNum) || this.m_slots_pending_delete.get(slotNum)) {
            return null;
        }
        return new ObjectFragment(this.m_buffer, this.m_objectOffsets[slotNum]);
    }

    void delete(byte slotNum) throws IOException {
        this.delete(slotNum, true);
    }

    private void delete(byte slotNum, boolean doLogging) throws IOException {
        this.delete(slotNum, true, false);
    }

    private void delete(byte slotNum, boolean doLogging, boolean deletePending) throws IOException {
        if (deletePending && !this.m_slots_pending_delete.get(slotNum)) {
            return;
        }
        if (!deletePending && this.m_slots_pending_delete.get(slotNum)) {
            throw new Error("Has pending delete flag");
        }
        if (deletePending) {
            this.m_slots_pending_delete.set((int)slotNum, false);
            this.storeSlotPendingDeleteBits();
        }
        ObjectFragment fragment = new ObjectFragment(this.m_buffer, this.m_objectOffsets[slotNum]);
        if (doLogging) {
            this.m_deleteNote.initNote(Dbkey.createDbkey(this.m_pageNum, slotNum), this.m_pageType, this.m_buffer, this.m_objectOffsets[slotNum] + fragment.getFragmentHeaderLength(), fragment.getFragmentLength(), fragment.isLeadFragment(), fragment.isLastFragment(), fragment.isLeadFragment() ? fragment.getClassType() : 0, fragment.isLeadFragment() ? fragment.getObjectLength() : 0L, !fragment.isLastFragment() ? fragment.getNextFragmentDbkey() : 0L);
            long noteID = this.m_logger.writeNote(this.m_deleteNote);
            this.m_page.setNoteID(noteID);
        }
        short numBytesDeleted = fragment.getTotalFragmentLength();
        byte slotLocation = this.shiftFollowers(slotNum, -numBytesDeleted);
        this.m_slots.set((int)slotNum, false);
        this.storeSlotBits();
        BitUtil.putShort(this.m_buffer, this.m_objects_pointers_offset + 2 * slotNum, (short)0);
        this.m_objectOffsets[slotNum] = 0;
        this.m_sortedOffsets.remove(slotLocation);
        if (!deletePending) {
            this.m_spaceUsed = (short)(this.m_spaceUsed - numBytesDeleted);
        }
    }

    private int getNumUsedSlots(boolean includeDeletePendingSlots) {
        int usedSlots = this.m_slots.cardinality();
        if (!includeDeletePendingSlots) {
            usedSlots -= this.m_slots_pending_delete.cardinality();
        }
        return usedSlots;
    }

    boolean hasFreeSlots() {
        return this.getNumUsedSlots(false) < 127;
    }

    boolean hasUsedSlots() {
        return this.getNumUsedSlots(false) > 0;
    }

    short getFreeSpace() {
        return (short)(this.m_total_available - 295 - this.m_spaceUsed - 23);
    }

    short getFreeSpace(BitSetUtil reservedSlots) {
        if (reservedSlots != null) {
            return (short)(this.getFreeSpace() - reservedSlots.cardinality() * 23);
        }
        return this.getFreeSpace();
    }

    private boolean hasRoom(short bytesNeeded) {
        return this.m_total_available - 295 - this.m_spaceUsed - bytesNeeded >= 0;
    }

    byte getEmptySlot(BitSetUtil reservedSlots) {
        if (this.getFreeSpace(reservedSlots) <= 0) {
            return -1;
        }
        BitSetUtil usedOrReserved = (BitSetUtil)this.m_slots.clone();
        usedOrReserved.or(reservedSlots);
        if (usedOrReserved.cardinality() == 127) {
            return -1;
        }
        return (byte)usedOrReserved.nextClearBit(0);
    }

    byte allocate(short fragmentSize, int classType, boolean leadFragment, boolean last, boolean useThisSlot, byte slotToUse, int totalObjectLength) throws IOException {
        return this.allocate(fragmentSize, classType, leadFragment, last, useThisSlot, slotToUse, true, false, totalObjectLength);
    }

    private byte allocate(short fragmentSize, int classType, boolean leadFragment, boolean last, boolean useThisSlot, byte slotToUse, boolean doLogging, boolean redo, int totalObjectLength) throws IOException {
        Object stateDEBUG = null;
        if (this.getNeedsReorg()) {
            if (doLogging || redo) {
                throw new Error("Cannot allocate a fragment in a page that needs reorganization");
            }
            throw new UndoRedoRedundancy();
        }
        short totalFragmentLength = (short)(ObjectFragment.calcHeaderLength(leadFragment, last) + fragmentSize);
        if (!doLogging && !this.hasRoom(totalFragmentLength)) {
            throw new UndoRedoRedundancy();
        }
        byte allocatedSlot = 0;
        short newFragmentStart = 0;
        int lastSlot = -1;
        if (!this.m_sortedOffsets.isEmpty()) {
            lastSlot = ((ObjectOffset)this.m_sortedOffsets.get((int)(this.m_sortedOffsets.size() - 1))).m_slotNum;
        }
        newFragmentStart = this.m_objects_offset;
        if (lastSlot != -1) {
            short lastFragmentStart = this.m_objectOffsets[lastSlot];
            ObjectFragment lastFragment = new ObjectFragment(this.m_buffer, lastFragmentStart);
            newFragmentStart = (short)(lastFragmentStart + lastFragment.getTotalFragmentLength());
        }
        allocatedSlot = useThisSlot ? slotToUse : (byte)this.m_slots.nextClearBit(0);
        if (doLogging) {
            this.m_createNote.initNote(Dbkey.createDbkey(this.m_pageNum, allocatedSlot), fragmentSize, classType, leadFragment, last, totalObjectLength);
            long noteID = this.m_logger.writeNote(this.m_createNote);
            this.m_page.setNoteID(noteID);
        }
        this.m_slots.set(allocatedSlot);
        this.storeSlotBits();
        this.m_sortedOffsets.add(new ObjectOffset(allocatedSlot, newFragmentStart));
        this.m_objectOffsets[allocatedSlot] = newFragmentStart;
        BitUtil.putShort(this.m_buffer, this.m_objects_pointers_offset + 2 * allocatedSlot, newFragmentStart);
        this.m_spaceUsed = (short)(this.m_spaceUsed + totalFragmentLength);
        ObjectFragment.createHeader(this.m_buffer, newFragmentStart, totalFragmentLength, classType, leadFragment, last, totalObjectLength);
        return allocatedSlot;
    }

    void replace(byte slotNum, byte[] newDataBuffer, int offset, short length, byte doLogging) throws IOException {
        ObjectFragment fragment = new ObjectFragment(this.m_buffer, this.m_objectOffsets[slotNum]);
        fragment.setInitialized();
        if (doLogging != 0) {
            short newDataLengthInNote = length;
            this.m_replaceNote.initNote(Dbkey.createDbkey(this.m_pageNum, slotNum), fragment.isLeadFragment(), fragment.isLastFragment(), fragment.isLeadFragment() ? fragment.getClassType() : 0, fragment.isLeadFragment() ? fragment.getObjectLength() : 0L, doLogging == 2 ? this.m_buffer : null, this.m_objectOffsets[slotNum] + fragment.getFragmentHeaderLength(), fragment.getFragmentLength(), newDataBuffer, offset, newDataLengthInNote);
            long noteID = this.m_logger.writeNote(this.m_replaceNote);
            this.m_page.setNoteID(noteID);
        }
        short oldLength = fragment.getFragmentLength();
        short delta = (short)(length - oldLength);
        if (doLogging == 0 && !this.hasRoom(delta)) {
            throw new UndoRedoRedundancy();
        }
        short newTotalLength = (short)(fragment.getFragmentHeaderLength() + length);
        fragment.setTotalFragmentLength(newTotalLength);
        this.m_spaceUsed = (short)(this.m_spaceUsed + delta);
        if (delta != 0) {
            this.shiftFollowers(slotNum, delta);
        }
        fragment.updateData(newDataBuffer, offset);
    }

    void updateData(byte slotNum, byte[] src, int offset) throws IOException {
        ObjectFragment fragment = this.getObjectFragment(slotNum);
        fragment.setInitialized();
        short newDataLengthInNote = fragment.getFragmentLength();
        this.m_replaceNote.initNote(Dbkey.createDbkey(this.m_pageNum, slotNum), fragment.isLeadFragment(), fragment.isLastFragment(), fragment.isLeadFragment() ? fragment.getClassType() : 0, fragment.isLeadFragment() ? fragment.getObjectLength() : 0L, null, 0, (short)0, src, offset, newDataLengthInNote);
        long noteID = this.m_logger.writeNote(this.m_replaceNote);
        fragment.updateData(src, offset);
        this.m_page.setNoteID(noteID);
    }

    void setNextFragmentDbkey(byte slotNum, long nextFragmentDbkey, boolean doLogging) throws IOException {
        if (doLogging) {
            this.m_nextFragmentNote.initNote(Dbkey.createDbkey(this.m_pageNum, slotNum), nextFragmentDbkey);
            long noteID = this.m_logger.writeNote(this.m_nextFragmentNote);
            this.m_page.setNoteID(noteID);
        }
        if (this.m_slots.get(slotNum)) {
            ObjectFragment fragment = this.getObjectFragment(slotNum);
            if (!fragment.isLastFragment()) {
                fragment.setNextFragmentDbkey(nextFragmentDbkey);
            }
        } else if (doLogging) {
            throw new Error("Could not find slot " + slotNum);
        }
    }

    byte[] getUsedSlots(boolean leadsOnly) {
        byte[] usedSlots = new byte[this.getNumUsedSlots(false)];
        int usedSlotsIndex = 0;
        for (int i = 0; i < 127; ++i) {
            if (!this.m_slots.get(i) || this.m_slots_pending_delete.get(i)) continue;
            boolean shouldBeIncluded = false;
            if (!leadsOnly) {
                shouldBeIncluded = true;
            } else {
                ObjectFragment fragment = new ObjectFragment(this.m_buffer, this.m_objectOffsets[i]);
                if (fragment.isLeadFragment()) {
                    shouldBeIncluded = true;
                }
            }
            if (!shouldBeIncluded) continue;
            usedSlots[usedSlotsIndex++] = (byte)i;
        }
        if (!leadsOnly) {
            return usedSlots;
        }
        byte[] leadUsedSlots = new byte[usedSlotsIndex];
        for (int i = 0; i < leadUsedSlots.length; ++i) {
            leadUsedSlots[i] = usedSlots[i];
        }
        return leadUsedSlots;
    }

    @Override
    public void undo(IContentBufferNote note) throws IOException {
        byte slotNum = ((IObjectsBufferNote)note).getSlotNum();
        if (note instanceof CreateNote) {
            this.undoCreate(slotNum);
        } else if (note instanceof DeleteBlobNote) {
            this.undoDeleteBlob(slotNum);
        } else if (note instanceof ReplaceNote) {
            this.undoReplace(slotNum, ((ReplaceNote)note).m_noUndoData, ((ReplaceNote)note).m_oldValue, ((ReplaceNote)note).m_oldOffset, ((ReplaceNote)note).m_oldLength);
        } else if (note instanceof DeleteNote) {
            this.undoDelete(slotNum, ((DeleteNote)note).m_oldValue, ((DeleteNote)note).m_offset, ((DeleteNote)note).m_length, ((DeleteNote)note).m_lead, ((DeleteNote)note).m_last, ((DeleteNote)note).m_classType, ((DeleteNote)note).m_totalObjectLength, ((DeleteNote)note).m_nextFragmentDbkey);
        } else if (!(note instanceof NextFragmentNote)) {
            throw new Error("Unknown note");
        }
    }

    @Override
    public void redo(IContentBufferNote note) throws IOException {
        block10: {
            try {
                byte slotNum = ((IObjectsBufferNote)note).getSlotNum();
                if (note instanceof CreateNote) {
                    if (!this.m_slots.get(slotNum)) {
                        this.allocate(((CreateNote)note).m_fragmentSize, ((CreateNote)note).m_classType, ((CreateNote)note).m_lead, ((CreateNote)note).m_last, true, slotNum, false, true, ((CreateNote)note).m_totalObjectLength);
                    }
                    break block10;
                }
                if (note instanceof DeleteBlobNote) {
                    this.delete(slotNum, false);
                    break block10;
                }
                if (note instanceof ReplaceNote) {
                    if (this.m_slots.get(slotNum)) {
                        this.replace(slotNum, ((ReplaceNote)note).m_newValue, ((ReplaceNote)note).m_newOffset, ((ReplaceNote)note).m_newLength, (byte)0);
                    }
                    break block10;
                }
                if (note instanceof DeleteNote) {
                    if (this.m_slots.get(slotNum)) {
                        this.delete(slotNum, false, false);
                    }
                    break block10;
                }
                if (note instanceof NextFragmentNote) {
                    this.setNextFragmentDbkey(slotNum, ((NextFragmentNote)note).m_nextFragmentDbk, false);
                    break block10;
                }
                throw new Error("Unknown note");
            }
            catch (UndoRedoRedundancy undoRedoRedundancy) {
                // empty catch block
            }
        }
    }

    private void undoDelete(byte slotNum, byte[] oldValue, int offset, short length, boolean lead, boolean last, int classType, long totalObjectLength, long nextFragmentDbkey) throws IOException {
        if (this.m_slots.get(slotNum)) {
            return;
        }
        try {
            this.allocate(length, classType, lead, last, true, slotNum, false, false, (int)totalObjectLength);
            this.replace(slotNum, oldValue, offset, length, (byte)0);
            if (!last) {
                this.setNextFragmentDbkey(slotNum, nextFragmentDbkey, false);
            }
        }
        catch (UndoRedoRedundancy u) {
            // empty catch block
        }
    }

    private void undoReplace(byte slotNum, boolean noData, byte[] oldValue, int offset, short length) throws IOException {
        if (noData) {
            return;
        }
        if (!this.m_slots.get(slotNum)) {
            return;
        }
        try {
            this.replace(slotNum, oldValue, offset, length, (byte)0);
        }
        catch (UndoRedoRedundancy u) {
            // empty catch block
        }
    }

    private void undoCreate(byte slotNum) throws IOException {
        if (!this.m_slots.get(slotNum) || this.getNeedsReorg()) {
            return;
        }
        this.delete(slotNum, false, false);
    }

    private void undoDeleteBlob(byte slotNum) throws IOException {
        if (!this.m_slots.get(slotNum) || !this.m_slots_pending_delete.get(slotNum)) {
            return;
        }
        this.m_slots_pending_delete.set((int)slotNum, false);
        this.storeSlotPendingDeleteBits();
        this.m_spaceUsed = (short)(this.m_spaceUsed + this.getObjectFragment(slotNum).getTotalFragmentLength());
        if (this.m_slots_pending_delete.cardinality() == 0) {
            this.setNeedsReorg(false);
        }
    }

    Object getCachedState() {
        return this.m_cachedState;
    }

    void setCachedState(Object state) {
        this.m_cachedState = state;
    }

    private static class ObjectOffset
    implements Comparable {
        byte m_slotNum;
        short m_offset;

        ObjectOffset(byte slotNum, short offset) {
            this.m_slotNum = slotNum;
            this.m_offset = offset;
        }

        static byte findSlot(ArrayList offsetsList, byte slot) {
            for (int i = 0; i < offsetsList.size(); ++i) {
                if (((ObjectOffset)offsetsList.get((int)i)).m_slotNum != slot) continue;
                return (byte)i;
            }
            throw new Error("Slot not found.");
        }

        public int compareTo(Object o) {
            if (this.m_offset < ((ObjectOffset)o).m_offset) {
                return -1;
            }
            if (this.m_offset > ((ObjectOffset)o).m_offset) {
                return 1;
            }
            return 0;
        }
    }
}

