/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitUtil;
import java.io.IOException;

class Page
implements Comparable {
    static final int PAGE_LENGTH = new Integer(System.getProperty("_PSEPageSize", "8192"));
    static final byte MAGIC_NUMBER = 37;
    static final byte NO_CHAIN = -1;
    static final byte NO_TYPE_PAGE = -1;
    static final byte INDEX_PAGE = 0;
    static final byte BLOBS_PAGE = 1;
    static final byte HEADERS_PAGE = 2;
    static final byte BTREE_PAGE = 3;
    static final byte FREE_PAGE = 4;
    static final byte MASTER_PAGE = 5;
    private static final short CRC_OFFSET = 0;
    private static final short PAGE_TYPE_OFFSET = 1;
    private static final short LATEST_NOTEID_OFFSET = 2;
    static final long UNKNOWN_PAGE_NUM = -1L;
    protected byte[] m_buffer = new byte[PAGE_LENGTH];
    protected long m_pageNum;
    private Long m_pageKey;

    Page() {
        this.initValues();
    }

    void copyBufferAndPageNum(Page src) {
        this.m_pageNum = src.m_pageNum;
        this.m_pageKey = src.m_pageKey;
        System.arraycopy(src.m_buffer, 0, this.m_buffer, 0, PAGE_LENGTH);
    }

    void copyIntoBuffer(byte[] target, int offset) {
        this.storeCRC();
        System.arraycopy(this.m_buffer, 0, target, offset, PAGE_LENGTH);
    }

    void useSameBufferAndPageNum(Page src) {
        this.m_pageNum = src.m_pageNum;
        this.m_pageKey = src.m_pageKey;
        this.m_buffer = src.m_buffer;
    }

    static byte mapPageType(byte pageType) {
        switch (pageType) {
            case 100: {
                return 0;
            }
            case 101: {
                return 2;
            }
            case 102: {
                return 2;
            }
        }
        throw new Error("Unknown page type");
    }

    void initValues() {
        this.m_buffer[0] = 37;
        this.setPageType((byte)4);
        this.m_pageKey = null;
        this.m_pageNum = -1L;
    }

    void validateNotCorrupt() throws IOException {
        if (this.m_buffer[0] != 37 && this.m_buffer[0] != this.calcCRC()) {
            throw new IOException("Page " + this.m_pageNum + " is corrupt.");
        }
    }

    public int compareTo(Object page) {
        if (this.m_pageNum < ((Page)page).m_pageNum) {
            return -1;
        }
        if (this.m_pageNum > ((Page)page).m_pageNum) {
            return 1;
        }
        return 0;
    }

    byte[] getBuffer() {
        return this.m_buffer;
    }

    long getPageNum() {
        return this.m_pageNum;
    }

    void setPageNum(long pageNum) {
        this.m_pageNum = pageNum;
        this.m_pageKey = new Long(pageNum);
    }

    Long getPageKey() {
        return this.m_pageKey;
    }

    byte getPageType() {
        return this.m_buffer[1];
    }

    void setPageType(byte type) {
        this.m_buffer[1] = type;
    }

    void setNoteID(long noteID) {
        BitUtil.putLong(this.m_buffer, 2, noteID);
    }

    static long getNoteID(byte[] buffer, int offset) {
        return BitUtil.getLong(buffer, offset + 2);
    }

    long getNoteID() {
        return BitUtil.getLong(this.m_buffer, 2);
    }

    void storeCRC() {
        this.m_buffer[0] = this.calcCRC();
    }

    byte calcCRC() {
        int interval = PAGE_LENGTH / 16;
        byte crc = 0;
        for (int i = 1; i < PAGE_LENGTH; i += interval) {
            crc = (byte)(crc + this.m_buffer[i] + i);
        }
        return crc;
    }
}

