/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IPageNote;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class PageChainNextNote
extends AbstractNote
implements IPageNote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 7;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNumber;
    long m_oldNextPage;
    long m_newNextPage;
    byte m_oldChainNumber;
    byte m_newChainNumber;

    PageChainNextNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNumber + " oldNextPage " + this.m_oldNextPage + " newNextPage " + this.m_newNextPage + " oldChainNumber " + this.m_oldChainNumber + " newChainNumber " + this.m_newChainNumber;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNumber;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)7);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNumber);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_oldNextPage);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_newNextPage);
        writer.write(this.m_scratchBuffer, 0, 8);
        writer.write(this.m_oldChainNumber);
        writer.write(this.m_newChainNumber);
        return 27;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_pageNumber = BitUtil.getLong(buffer, currentOffset);
        this.m_oldNextPage = BitUtil.getLong(buffer, currentOffset += 8);
        this.m_newNextPage = BitUtil.getLong(buffer, currentOffset += 8);
        currentOffset += 8;
        this.m_oldChainNumber = buffer[currentOffset++];
        this.m_newChainNumber = buffer[currentOffset];
    }

    void initNote(long pageNumber, long oldNextPage, long newNextPage, byte oldChainNumber, byte newChainNumber) {
        this.m_pageNumber = pageNumber;
        this.m_oldNextPage = oldNextPage;
        this.m_newNextPage = newNextPage;
        this.m_oldChainNumber = oldChainNumber;
        this.m_newChainNumber = newChainNumber;
    }
}

