/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class ReplicationState {
    private static final String REPLICATION_STATE_FILE_NAME_1 = "replication_state";
    private static final String REPLICATION_STATE_FILE_NAME_2 = "replication_state_2";
    private short m_defaultState;

    ReplicationState(short dfltState) {
        this.m_defaultState = dfltState;
    }

    public void setPersistentReplicationState(String storageName, short state) throws IOException {
        File dbDir = new File(storageName);
        if (!dbDir.exists()) {
            return;
        }
        File stateFile1 = new File(dbDir, REPLICATION_STATE_FILE_NAME_1);
        File stateFile2 = new File(dbDir, REPLICATION_STATE_FILE_NAME_2);
        File stateFile = this.nextStateFileToWrite(stateFile1, stateFile2);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(stateFile));
        oos.writeObject(new Short(state));
        oos.close();
        if (stateFile == stateFile1) {
            stateFile2.delete();
        } else {
            stateFile1.delete();
        }
    }

    public short getPersistentReplicationState(String storageName) throws IOException {
        File dbDir = new File(storageName);
        if (!dbDir.exists()) {
            return this.m_defaultState;
        }
        File stateFile1 = new File(dbDir, REPLICATION_STATE_FILE_NAME_1);
        File stateFile2 = new File(dbDir, REPLICATION_STATE_FILE_NAME_2);
        File stateFileToWrite = this.nextStateFileToWrite(stateFile1, stateFile2);
        File stateFile = stateFileToWrite == stateFile1 ? stateFile2 : stateFile1;
        Short value = this.getStateFromFile(stateFile);
        if (value == null) {
            throw new IOException("Storage corruption: No replication state for " + storageName);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Short getStateFromFile(File stateFile) {
        Short s;
        ObjectInputStream ois = null;
        FileInputStream fi = null;
        try {
            if (!stateFile.exists()) {
                Short s2 = null;
                return s2;
            }
            fi = new FileInputStream(stateFile);
            ois = new ObjectInputStream(fi);
            s = (Short)ois.readObject();
        }
        catch (Exception e) {
            Short s3 = null;
            return s3;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {}
            } else if (fi != null) {
                try {
                    fi.close();
                }
                catch (Exception e) {}
            }
        }
        return s;
    }

    private File nextStateFileToWrite(File stateFile1, File stateFile2) {
        boolean file1Exists = stateFile1.exists();
        boolean file2Exists = stateFile2.exists();
        if (!file1Exists && !file2Exists) {
            return stateFile1;
        }
        if (file1Exists && file2Exists) {
            File nextFile = null;
            Short val1 = this.getStateFromFile(stateFile1);
            Short val2 = this.getStateFromFile(stateFile2);
            if (val1 != null && val2 != null) {
                return stateFile1.lastModified() > stateFile2.lastModified() ? stateFile2 : stateFile1;
            }
            nextFile = val1 != null ? stateFile2 : stateFile1;
            nextFile.delete();
            return nextFile;
        }
        if (file1Exists) {
            return stateFile2;
        }
        return stateFile1;
    }
}

