/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BTreeManager;
import com.sonicsw.mtstorage.impl.Storage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

final class SnapshotStorage {
    static String SNAPSHOT_DIR = "snapshot";
    private Storage m_storage;
    private Long m_transaction;

    SnapshotStorage() {
    }

    void open(File hostDir) throws IOException {
        File snapshotDir = new File(hostDir, SNAPSHOT_DIR);
        SnapshotStorage.cleanup(snapshotDir);
        this.m_storage = new Storage();
        HashMap<String, Comparable<Boolean>> parameters = new HashMap<String, Comparable<Boolean>>();
        parameters.put("NO_LOGGING", Boolean.TRUE);
        parameters.put("NO_CHECKPOINT", Boolean.TRUE);
        parameters.put("ASYNC_PAGE_WRITING", Boolean.FALSE);
        parameters.put("SNAPSHOT_STORAGE_PARAMETER", Boolean.TRUE);
        parameters.put("INDEX_CACHE_SIZE", new Integer(1));
        parameters.put("BLOBS_CACHE_SIZE", new Integer(1));
        parameters.put("HEADERS_CACHE_SIZE", new Integer(1));
        parameters.put("FREE_PAGES_CACHE_SIZE", new Integer(500));
        parameters.put("BTREE_CACHE_SIZE", new Integer(500));
        parameters.put("WRITE_DIRTY_PAGES_THRESHOLD", new Integer(1000));
        this.m_storage.open(snapshotDir.getAbsolutePath(), true, parameters);
        this.m_transaction = this.m_storage.begin();
    }

    Long getTransaction() {
        return this.m_transaction;
    }

    void close() {
        try {
            this.m_storage.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    BTreeManager getBTreeManager() throws IOException {
        return (BTreeManager)this.m_storage.getBTreeManager();
    }

    private static void cleanup(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            file.delete();
            return;
        }
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            SnapshotStorage.cleanup(files[i]);
        }
        file.delete();
    }
}

