/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.ITransactionControl;
import java.io.IOException;

final class TransactionEndNote
extends AbstractNote
implements ITransactionControl {
    static final byte NOTE_TYPE = 41;
    byte[] m_scratchBuffer = new byte[8];
    boolean m_committed;
    long m_transactionNum;

    @Override
    public long getPageNum() {
        return 0L;
    }

    @Override
    public long getTransactionNum() {
        return this.m_transactionNum;
    }

    TransactionEndNote() {
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)41);
        writer.write((byte)(this.m_committed ? 1 : 0));
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_transactionNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 10;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_committed = buffer[currentOffset++] == 1;
        this.m_transactionNum = BitUtil.getLong(buffer, currentOffset);
    }

    void initNote(long transactionNum, boolean committed) {
        this.m_transactionNum = transactionNum;
        this.m_committed = committed;
    }
}

