/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.sonicsw.mtstorage.IStorage;
import com.sonicsw.mtstorage.impl.LogPage;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.replication.AbstractCommunicationManager;
import com.sonicsw.mtstorage.replication.IReplicatedStorage;
import com.sonicsw.mtstorage.replication.ReplicationManager;
import com.sonicsw.mtstorage.replication.StateManager;
import com.sonicsw.mtstorage.replication.util.Tracer;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.IDiagnosticsHistoryTracker;
import java.io.IOException;
import java.util.HashMap;

public final class ActiveStorageManager {
    private static final String TRANSACTION_TIMEOUT_REPLICATION_PARAMETER = "REPLICATION_TIMEOUT";
    private static final String MAX_REPLICATION_LOG_SIZE_PARAMETER = "MAX_REPLICATION_LOG_SIZE";
    private static final Integer TRANSACTION_TIMEOUT_REPLICATION_DEFAULT = new Integer(-1);
    private static final Integer MAX_REPLICATION_LOG_SIZE_DEFAULT = new Integer(80);
    private static final int UNKNOWN_LOG_ID = -1;
    private static final int REPLICATED_STATUS_REPLICATED = 0;
    private static final int REPLICATED_STATUS_NOT_REPLICATED = 1;
    IReplicatedStorage m_activeStorage;
    private AbstractCommunicationManager m_commManager;
    private StateManager m_stateManager;
    private long m_nextLogIDToReplicate;
    private long m_IDAfterLargestTransEnd;
    private boolean m_peerAccessible;
    private RequestHandler m_requestHandler;
    private boolean m_closed = false;
    private long m_waitForReplicationTimeoutMillis;
    private boolean m_open = false;
    private boolean m_preShutdown = false;
    IDiagnosticsContext m_diagnosticsContext;
    private IDiagnosticsHistoryTracker m_requestHistory;
    private IDiagnosticsHistoryTracker m_responseHistory;
    private IDiagnosticsHistoryTracker m_transactionHistory;
    private boolean m_toldStandbyItsNotDirty = false;

    ActiveStorageManager(IDiagnosticsContext diagnosticsContext) {
        this.m_diagnosticsContext = diagnosticsContext;
        this.m_requestHandler = new RequestHandler();
    }

    synchronized void preShutdown() {
        this.m_preShutdown = true;
    }

    synchronized void open(String dbName, HashMap storageParameters, AbstractCommunicationManager commManager, StateManager stateManager, boolean peerAccessible) throws IOException {
        Integer maxLog;
        Tracer.TRACE("ActiveStorageManager try to open storage: " + dbName + " ...");
        if (this.m_closed) {
            return;
        }
        this.m_requestHistory = this.m_diagnosticsContext.createHistoryTrackerObject("ActiveStorageManager Request History", (Object[])ReplicationManager.SDFRequestTracker.getCache());
        this.m_responseHistory = this.m_diagnosticsContext.createHistoryTrackerObject("ActiveStorageManager Response History", (Object[])ReplicationManager.SDFResponseTracker.getCache());
        this.m_transactionHistory = this.m_diagnosticsContext.createHistoryTrackerObject("ActiveStorageManager Transaction History", (Object[])ReplicationManager.SDFTransactionTracker.getCache());
        this.m_stateManager = stateManager;
        this.m_peerAccessible = peerAccessible;
        this.m_commManager = commManager;
        this.m_nextLogIDToReplicate = -1L;
        Storage storage = new Storage();
        Integer transactionTimeout = (Integer)storageParameters.get(TRANSACTION_TIMEOUT_REPLICATION_PARAMETER);
        if (transactionTimeout == null) {
            transactionTimeout = TRANSACTION_TIMEOUT_REPLICATION_DEFAULT;
        }
        if ((maxLog = (Integer)storageParameters.get(MAX_REPLICATION_LOG_SIZE_PARAMETER)) == null) {
            maxLog = MAX_REPLICATION_LOG_SIZE_DEFAULT;
        }
        this.m_waitForReplicationTimeoutMillis = transactionTimeout < 0 ? Long.MAX_VALUE : (long)(transactionTimeout * 1000);
        this.setStorage(storage, maxLog * 1000000);
        storage.open(dbName, false, storageParameters);
        if (!stateManager.isActiveDirty() && this.m_activeStorage.transactionEndedDuringRecovery()) {
            this.m_stateManager.stateDirty(true);
        }
        this.m_IDAfterLargestTransEnd = this.m_activeStorage.getIDAfterLastTransEnd();
        this.m_requestHandler.openned();
        this.m_open = true;
        Tracer.TRACE("ActiveStorageManager Open storage: " + dbName + " done");
    }

    IStorage getStorage() {
        return (IStorage)((Object)this.m_activeStorage);
    }

    private void setStorage(IReplicatedStorage storage, long maxLog) {
        this.m_activeStorage = storage;
        this.m_activeStorage.setActiveReplicationContext(this, maxLog);
    }

    private int handleLogRequest(long requestedLogID, long requestID, long deepSyncLastNoteWrittenAfterPageReplication) throws IOException, InterruptedException {
        this.updateReplicationState(requestedLogID);
        ReplicationManager.ReplicationDataIndicator indicator = this.m_activeStorage.getLogDataForReplication(requestedLogID, deepSyncLastNoteWrittenAfterPageReplication);
        if (indicator == null) {
            ReplicationManager.SDFResponseTracker responseTracker = (ReplicationManager.SDFResponseTracker)this.m_responseHistory.getHistoryItem();
            responseTracker.setResponse(new HashMap(), 0, Boolean.FALSE, 0L, null);
            return 1;
        }
        if (!indicator.m_okStatus) {
            this.updateReplicationStateDeepSync();
            return this.sendData(this.m_activeStorage.startDeepSync(), requestID);
        }
        indicator.m_syncLog = this.standbyMustSyncLogData(requestedLogID, indicator);
        return this.sendData(indicator, requestID);
    }

    private synchronized void updateReplicationStateDeepSync() {
        this.m_stateManager.stateDirty(true);
        this.m_nextLogIDToReplicate = -1L;
        this.notifyAll();
    }

    private synchronized boolean standbyMustSyncLogData(long requestedLogID, ReplicationManager.ReplicationDataIndicator indicator) throws IOException {
        boolean transEndLargeThanDataStartExists = this.m_activeStorage.getIDAfterLastTransEnd() > requestedLogID;
        return transEndLargeThanDataStartExists && this.m_IDAfterLargestTransEnd <= requestedLogID + (long)indicator.m_dataLength;
    }

    private synchronized void updateReplicationState(long requestedLogID) {
        this.m_stateManager.stateDirty(requestedLogID < this.m_IDAfterLargestTransEnd);
        this.m_nextLogIDToReplicate = requestedLogID;
        this.notifyAll();
    }

    private synchronized boolean willRemainDirtyWhenDataGetThere(ReplicationManager.ReplicationDataIndicator indicator) {
        boolean tellStandbyItsDirty = indicator.m_dataID + (long)indicator.m_dataLength < this.m_IDAfterLargestTransEnd;
        this.m_toldStandbyItsNotDirty = !tellStandbyItsDirty;
        return tellStandbyItsDirty;
    }

    private int sendData(ReplicationManager.ReplicationDataIndicator indicator, long requestID) {
        indicator.m_requestID = requestID;
        if (!indicator.m_logData) {
            indicator.m_dirtyFlag = true;
            this.m_toldStandbyItsNotDirty = false;
        } else {
            indicator.m_dirtyFlag = this.willRemainDirtyWhenDataGetThere(indicator);
        }
        HashMap indicatorMap = indicator.toHashmap();
        try {
            this.m_commManager.sendReplicationMessage(indicatorMap, indicator.m_buffer, indicator.m_dataOffset, indicator.m_dataLength);
            ReplicationManager.SDFResponseTracker responseTracker = (ReplicationManager.SDFResponseTracker)this.m_responseHistory.getHistoryItem();
            responseTracker.setResponse(indicatorMap, indicator.m_dataLength, Boolean.TRUE, 0L, null);
        }
        catch (IOException e) {
            ReplicationManager.SDFResponseTracker responseTracker = (ReplicationManager.SDFResponseTracker)this.m_responseHistory.getHistoryItem();
            responseTracker.setResponse(indicatorMap, indicator.m_dataLength, Boolean.FALSE, 0L, e.toString());
            Tracer.TRACE("ActiveStorageManager send data request ID " + requestID + " failed");
            Tracer.TRACE(e);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        Tracer.TRACE("ActiveStorageManager close storage");
        ActiveStorageManager activeStorageManager = this;
        synchronized (activeStorageManager) {
            this.m_closed = true;
            this.notifyAll();
        }
        this.m_requestHandler.close();
        if (this.m_activeStorage != null && this.m_open) {
            this.m_activeStorage.stopRecoveryCloseImmediately();
        }
    }

    void setRequest(HashMap request) {
        this.m_requestHandler.setRequest(request);
    }

    private int handleRequest(HashMap request) throws IOException, InterruptedException {
        ReplicationManager.SDFRequestTracker requestTracker = (ReplicationManager.SDFRequestTracker)this.m_requestHistory.getHistoryItem();
        requestTracker.setRequest(request);
        if (((Boolean)request.get("REQUEST_LOG_DATA")).booleanValue()) {
            return this.handleLogRequest((Long)request.get("REQUEST_DATAID"), (Long)request.get("REQUEST_ID"), (Long)request.get("REQUEST_DEEPSYNC_LAST_NOTE_AFTER_PAGE_REPLICATION"));
        }
        this.updateReplicationStateDeepSync();
        ReplicationManager.DeepSyncRequest deepSyncReq = new ReplicationManager.DeepSyncRequest(request);
        return this.sendData(this.m_activeStorage.getDeepSyncData(deepSyncReq), deepSyncReq.m_requestID);
    }

    synchronized void peerAccessible(boolean accessible) {
        Tracer.TRACE("ActiveStorageManager peer accessible " + accessible);
        this.m_peerAccessible = accessible;
        this.notifyAll();
    }

    private static long MAX(long l1, long l2) {
        return l1 > l2 ? l1 : l2;
    }

    public synchronized int waitForLogReplication(long afterTransEndLogID) {
        long timetowait;
        long starttime = System.currentTimeMillis();
        ReplicationManager.SDFTransactionTracker transactionTracker = (ReplicationManager.SDFTransactionTracker)this.m_transactionHistory.getHistoryItem();
        transactionTracker.waitingTransaction(afterTransEndLogID, starttime, timetowait, this.m_peerAccessible, this.m_nextLogIDToReplicate, this.m_stateManager.isActiveDirty(), this.m_toldStandbyItsNotDirty);
        for (timetowait = this.m_preShutdown ? 0L : this.m_waitForReplicationTimeoutMillis; this.m_peerAccessible && !this.m_closed && timetowait > 0L && ActiveStorageManager.needToWaitForStandbyToReplicate(afterTransEndLogID, this.m_nextLogIDToReplicate) && (!this.m_stateManager.isActiveDirty() || this.m_toldStandbyItsNotDirty) && !this.m_stateManager.shuttingDown(); timetowait -= System.currentTimeMillis() - starttime) {
            try {
                this.wait(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Tracer.TRACE(e);
            }
        }
        this.m_IDAfterLargestTransEnd = ActiveStorageManager.MAX(this.m_IDAfterLargestTransEnd, afterTransEndLogID);
        boolean wasNotReplicated = afterTransEndLogID > this.m_nextLogIDToReplicate;
        transactionTracker.doneWaitingTransaction(wasNotReplicated);
        if (wasNotReplicated) {
            this.m_stateManager.stateDirty(true);
            return 1;
        }
        return 0;
    }

    private static boolean needToWaitForStandbyToReplicate(long afterTransEndLogID, long nextLogIDToReplicate) {
        if (afterTransEndLogID > nextLogIDToReplicate) {
            return nextLogIDToReplicate % (long)LogPage.PAGE_LENGTH != 0L || nextLogIDToReplicate + 8L != afterTransEndLogID;
        }
        return false;
    }

    void printState(StringBuffer buffer) {
        this.m_requestHistory.appendHistory(buffer);
        this.m_responseHistory.appendHistory(buffer);
        this.m_transactionHistory.appendHistory(buffer);
    }

    private class RequestHandler
    extends Thread {
        HashMap m_request;
        boolean m_closing;
        boolean m_open;

        RequestHandler() {
            super("ActiveStorageManager.RequestHandler Thread");
            this.m_request = null;
            this.m_closing = false;
            this.m_open = false;
            this.setDaemon(true);
            this.start();
        }

        synchronized void openned() {
            this.m_open = true;
            this.notifyAll();
        }

        synchronized void setRequest(HashMap request) {
            this.m_request = request;
            if (this.m_open && !this.m_closing) {
                ActiveStorageManager.this.m_activeStorage.stopWaitingForData();
            }
            this.notifyAll();
        }

        private synchronized void resetRequest() {
            this.m_request = null;
        }

        private synchronized void waitForRequest() {
            while (this.m_request == null && !this.m_closing || !this.m_open) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Tracer.TRACE(e);
                }
            }
        }

        private synchronized void close() {
            this.m_closing = true;
            if (ActiveStorageManager.this.m_activeStorage != null && this.m_open) {
                ActiveStorageManager.this.m_activeStorage.stopWaitingForData();
            }
            this.notifyAll();
        }

        private synchronized boolean isClosing() {
            return this.m_closing;
        }

        @Override
        public void run() {
            while (true) {
                this.waitForRequest();
                if (this.isClosing()) {
                    return;
                }
                try {
                    HashMap req = this.m_request;
                    this.resetRequest();
                    ActiveStorageManager.this.handleRequest(req);
                    continue;
                }
                catch (IOException e) {
                    Tracer.TRACE(e);
                    if (this.isClosing()) continue;
                    ActiveStorageManager.this.m_stateManager.shutdownState(e);
                    continue;
                }
                catch (InterruptedException e) {
                    Tracer.TRACE(e);
                    continue;
                }
                catch (Throwable t) {
                    Tracer.TRACE(t);
                    continue;
                }
                break;
            }
        }
    }
}

