/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.sonicsw.mtstorage.replication.BlackbirdCommunicationManager;
import com.sonicsw.mtstorage.replication.ftchannel.ChannelConstants;
import com.sonicsw.mtstorage.replication.ftchannel.IChannelListener;
import java.io.IOException;
import java.util.HashMap;

abstract class PeerConnection
implements ChannelConstants {
    PeerConnection() {
    }

    abstract void open(HashMap[] var1, HashMap var2, IChannelListener var3, BlackbirdCommunicationManager.ConnectionHandler var4, boolean var5) throws InterruptedException;

    abstract void send(byte[] var1, int var2, int var3) throws IOException;

    abstract void close(boolean var1);

    abstract boolean isConnected();

    abstract void doNotReportFailure();

    static HashMap[] filterConnectionParameters(HashMap[] connsConfigs, boolean primaryConnParameters, boolean thisPrimary) {
        HashMap[] filteredList = new HashMap[connsConfigs.length];
        for (int i = 0; i < connsConfigs.length; ++i) {
            HashMap<String, String> filtered = new HashMap<String, String>();
            String role = primaryConnParameters ? "PRIMARY_" : "BACKUP_";
            String myRole = thisPrimary ? "PRIMARY_" : "BACKUP_";
            String host = (String)connsConfigs[i].get(role + "ADDR");
            String myHost = (String)connsConfigs[i].get(myRole + "ADDR");
            if (host == null) {
                host = "localhost";
            }
            if (myHost == null) {
                myHost = "localhost";
            }
            filtered.put("HOST", host);
            filtered.put("MY_HOST", myHost);
            filtered.put("PROTOCOL", (String)connsConfigs[i].get("PROTOCOL"));
            filtered.put("WEIGHT", (String)connsConfigs[i].get("WEIGHT"));
            filtered.put("PORT", (String)connsConfigs[i].get(role + "PORT"));
            filteredList[i] = filtered;
        }
        return filteredList;
    }

    static {
        if (System.getProperty("bb.io.trace") == null && System.getProperty("bb.logger.device") == null) {
            System.setProperty("bb.logger.device", "null");
        }
    }
}

