/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.sonicsw.mtstorage.replication.BlackbirdCommunicationManager;
import com.sonicsw.mtstorage.replication.PeerConnection;
import com.sonicsw.mtstorage.replication.ftchannel.ChannelConstants;
import com.sonicsw.mtstorage.replication.ftchannel.IActiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.IChannelListener;
import com.sonicsw.mtstorage.replication.ftchannel.IPassiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.PermanentException;
import com.sonicsw.mtstorage.replication.ftchannel.blackbird.PassiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.socket.ActiveChannel;
import com.sonicsw.mtstorage.replication.util.Tracer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;

final class PrimaryConnection
extends PeerConnection {
    private static final boolean USE_BLACKBIRD = System.getProperty("_TEST_do_not_use_blackbird") == null;
    private IActiveChannel m_activeChannel = null;
    private boolean m_accepting = false;
    private boolean m_closing = false;
    private boolean m_alwaysRetry = false;
    private IPassiveChannel m_passiveChannel = null;
    private HashMap m_commParameters = null;

    PrimaryConnection() {
    }

    @Override
    void open(final HashMap[] connsConfigs, HashMap commParameters, IChannelListener channelListener, final BlackbirdCommunicationManager.ConnectionHandler connHandler, boolean alwaysRetry) throws InterruptedException {
        this.m_commParameters = commParameters;
        this.m_alwaysRetry = alwaysRetry;
        this.acceptAsync(PrimaryConnection.filterConnectionParameters(connsConfigs, true, true), channelListener, connHandler);
        this.waitUntilAccepting();
        if (this.m_closing) {
            return;
        }
        Thread alertThread = new Thread("PrimaryConnection Alert Backup Primary Started Thread"){

            @Override
            public void run() {
                Tracer.TRACE("Starting a thread to alret BACKUP that PRIMARY is starting...");
                PrimaryConnection.this.alertBackup(PeerConnection.filterConnectionParameters(connsConfigs, false, true), connHandler);
            }
        };
        alertThread.setDaemon(true);
        alertThread.start();
    }

    @Override
    void doNotReportFailure() {
        if (this.m_activeChannel != null) {
            try {
                this.m_activeChannel.doNotReportFailure();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    boolean isConnected() {
        return this.m_activeChannel != null;
    }

    @Override
    void send(byte[] data, int offset, int length) throws IOException {
        if (this.m_activeChannel == null) {
            throw new IOException("The connection is down");
        }
        this.m_activeChannel.send(data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alertBackup(HashMap[] connsConfigs, BlackbirdCommunicationManager.ConnectionHandler connHandler) {
        for (int i = 0; i < 3; ++i) {
            if (this.m_closing) {
                return;
            }
            ChannelConstants primaryIsUp = null;
            try {
                primaryIsUp = USE_BLACKBIRD ? new com.sonicsw.mtstorage.replication.ftchannel.blackbird.ActiveChannel() : new ActiveChannel();
                primaryIsUp.open(connsConfigs, null, null, false, true, false);
                return;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
            catch (PermanentException e) {
                System.out.println("PSE replication warning: Failed to notify BACKUP that PRIMARY is running - " + e.toString());
                continue;
            }
            finally {
                if (primaryIsUp != null) {
                    try {
                        primaryIsUp.close(false);
                    }
                    catch (Throwable t) {
                        Tracer.TRACE(t);
                    }
                }
            }
        }
    }

    @Override
    synchronized void close(boolean unused) {
        if (this.m_closing) {
            return;
        }
        this.m_closing = true;
        this.notifyAll();
        if (this.m_activeChannel != null) {
            this.m_activeChannel.close(true);
            this.m_activeChannel = null;
        }
        if (this.m_passiveChannel != null) {
            this.m_passiveChannel.interruptAccept();
        }
        this.m_passiveChannel.close();
    }

    private synchronized void accepting() {
        this.m_accepting = true;
        this.notifyAll();
    }

    private synchronized void waitUntilAccepting() throws InterruptedException {
        while (!this.m_accepting) {
            if (this.m_closing) {
                return;
            }
            this.wait();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void acceptAsync(HashMap[] connsConfigs, final IChannelListener channelListener, final BlackbirdCommunicationManager.ConnectionHandler connHandler) {
        this.m_passiveChannel = USE_BLACKBIRD ? new PassiveChannel() : new com.sonicsw.mtstorage.replication.ftchannel.socket.PassiveChannel();
        try {
            this.m_passiveChannel.open(connsConfigs, this.m_commParameters, this.m_alwaysRetry, true, true);
        }
        catch (IOException e) {
            connHandler.connectFailed(this.m_alwaysRetry ? e : new PermanentException(e));
            return;
        }
        Thread acceptThread = new Thread("PrimaryConnection Accept Thread"){

            @Override
            public void run() {
                try {
                    PrimaryConnection.this.accepting();
                    PrimaryConnection.this.m_activeChannel = PrimaryConnection.this.m_passiveChannel.accept(channelListener);
                    PrimaryConnection.this.m_passiveChannel.accepted();
                    connHandler.connected();
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    PrimaryConnection.this.m_passiveChannel.close();
                    connHandler.connectFailed(new PermanentException(e));
                }
            }
        };
        acceptThread.setDaemon(true);
        acceptThread.start();
    }
}

