/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.odi.ReplicationController;
import com.sonicsw.mtstorage.replication.ICommunicationStatusHandler;
import com.sonicsw.mtstorage.replication.IMessageHandler;
import com.sonicsw.mtstorage.replication.IStateListener;
import com.sonicsw.mtstorage.replication.util.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public final class StateManager {
    private static final int TEMP_CONN_DELAY_TIMEOUT = 90;
    private static final String BOTH_ACTIVE_ERROR_MSG = "Both PRIMARY and BACKUP contain unreplicated modifications. Choose which to preserve, the PRIMARY or BACKUP, and add the line 'SystemProperty.sonicsw.mf.DS.startactive=true' to the associated container.ini file. Alternatively, the data storage directory of either the PRIMARY or BACKUP may be deleted so it can be replicated from the other";
    public static final short NO_STATE = 0;
    public static final short PREPARE_FLAG = 1024;
    public static final short DEEP_SYNC_FLAG = 512;
    public static final short WAITING = 1;
    public static final short ACTIVE_DIRTY = 2;
    public static final short PREPARING_ACTIVE_DIRTY = 1026;
    public static final short ACTIVE_CLEAN = 3;
    public static final short PREPARING_ACTIVE_CLEAN = 1027;
    public static final short STANDBY = 4;
    public static final short SYNCHRONIZING_STANDBY = 5;
    public static final short DEEP_SYNCHRONIZING_STANDBY = 517;
    public static final short SHUTTING_DOWN = 6;
    private boolean m_peerAccessible;
    private State m_state;
    private boolean m_thisPrimary;
    private boolean m_initialStateAnnounced = false;
    private boolean m_autoDualActiveResolve;
    private String m_peerRole;
    private ReplicationController m_storageController;
    private Boolean m_activationMonitor;
    private int m_detectionFailureTimeout;
    private int m_detectionFailureTimeoutSave;
    private boolean m_tempTimeoutON = false;
    private Activator m_activator;
    private ArrayList m_listeners;

    IMessageHandler getMessageHandler() {
        return new PeerStateHandler();
    }

    ICommunicationStatusHandler getCommHandler() {
        return new CommHandler();
    }

    StateManager(ReplicationController pseConroller, boolean thisPrimary, boolean startActive, long dbTimestamp, boolean autoDualActiveResolve, short prevPersistentState, int detectionFailureTimeout) throws IOException {
        this.m_detectionFailureTimeout = detectionFailureTimeout;
        if (startActive && prevPersistentState == 517) {
            throw new IOException("Cannot start active when the storage is in a deep synchronization state");
        }
        this.m_storageController = pseConroller;
        this.m_peerRole = thisPrimary ? "BACKUP" : "PRIMARY";
        this.m_listeners = new ArrayList();
        this.m_activationMonitor = new Boolean(true);
        this.m_thisPrimary = thisPrimary;
        this.m_autoDualActiveResolve = autoDualActiveResolve;
        this.m_peerAccessible = true;
        short initialState = startActive ? (short)1027 : 1;
        this.m_state = new State(initialState, prevPersistentState, startActive, dbTimestamp);
        Tracer.TRACE("StateManager initial state " + this.m_state + " initial m_detectionFailureTimeout " + this.m_detectionFailureTimeout);
    }

    private void setTempTimeout() {
        if (this.m_tempTimeoutON) {
            return;
        }
        this.m_tempTimeoutON = true;
        this.m_detectionFailureTimeoutSave = this.m_detectionFailureTimeout;
        if (90 > this.m_detectionFailureTimeout) {
            this.m_detectionFailureTimeout = 90;
        }
        Tracer.TRACE("StateManager set m_detectionFailureTimeout to " + this.m_detectionFailureTimeout);
    }

    private void restoreTimeout() {
        if (!this.m_tempTimeoutON) {
            return;
        }
        this.m_detectionFailureTimeout = this.m_detectionFailureTimeoutSave;
        this.m_tempTimeoutON = false;
        Tracer.TRACE("StateManager set m_detectionFailureTimeout to " + this.m_detectionFailureTimeout);
    }

    synchronized long getPeerDbTimestamp() {
        return this.m_state.m_peerDbTimestamp;
    }

    synchronized boolean inAnyStandby() {
        return this.m_state.m_currentState == 4 || this.m_state.m_currentState == 5 || this.m_state.m_currentState == 517;
    }

    synchronized boolean inDeepSyncState() {
        return (this.m_state.m_currentState & 0x200) != 0;
    }

    synchronized boolean shuttingDown() {
        return this.m_state.m_currentState == 6;
    }

    synchronized void announceInitialState() {
        if (!this.m_initialStateAnnounced) {
            this.announceState(this.m_state);
        }
    }

    synchronized boolean isActiveDirty() {
        return StateManager.removePrepareFlag(this.m_state.m_currentState) == 2;
    }

    synchronized void setStandbyState(short newState) {
        if (this.m_state.m_currentState != 4 && this.m_state.m_currentState != 5 && this.m_state.m_currentState != 517) {
            return;
        }
        this.setState(newState);
    }

    synchronized void setState(short newState) {
        if (this.m_state.m_currentState != newState) {
            this.m_state.setNewState(newState);
            this.announceState(this.m_state);
        }
    }

    synchronized void stateDirty(boolean isDirty) {
        short newState;
        boolean preparingForActive = (short)(this.m_state.m_currentState & 0x400) != 0;
        short flagWithoutPrep = StateManager.removePrepareFlag(this.m_state.m_currentState);
        if (flagWithoutPrep != 2 && flagWithoutPrep != 3) {
            return;
        }
        short s = newState = isDirty ? (short)2 : 3;
        if (preparingForActive) {
            newState = (short)(newState | 0x400);
        }
        this.setState(newState);
    }

    synchronized void activationDone() {
        if ((short)(this.m_state.m_currentState & 0x400) != 0) {
            this.m_state.setNewState((short)(this.m_state.m_currentState & 0xFFFFFBFF));
            this.announceState(this.m_state);
        }
    }

    void addListener(IStateListener listener) {
        this.m_listeners.add(listener);
    }

    synchronized void shutdownState(String reason) {
        if (this.m_state.m_currentState == 6) {
            return;
        }
        this.announceState(this.m_state, true);
        this.m_state.setShuttingdown(reason);
        this.announceState(this.m_state);
    }

    synchronized void shutdownState(Exception e) {
        if (this.m_state.m_currentState == 6) {
            return;
        }
        this.announceState(this.m_state, true);
        this.m_state.setShuttingdown(e);
        this.announceState(this.m_state);
    }

    private synchronized void peerStateChanged(HashMap peerStateMap) {
        Boolean tmp = (Boolean)peerStateMap.get("TEMPORARY_CONNECTION");
        if (tmp != null && tmp.booleanValue()) {
            this.setTempTimeout();
        } else {
            this.restoreTimeout();
        }
        State peerState = new State(peerStateMap);
        Tracer.TRACE("StateManager.peerStateChanged " + peerState);
        this.m_state.m_peerDbTimestamp = peerState.m_dbTimestamp;
        if (this.m_state.m_startActive && peerState.m_startActive) {
            this.shutdownState("Shutting down since both the PRIMARY and the BACKUP where started with the start_active flag");
            return;
        }
        if (this.m_state.m_dbTimestamp != peerState.m_dbTimestamp && this.m_state.m_dbTimestamp != 0L && peerState.m_dbTimestamp != 0L && !this.m_state.m_startActive) {
            this.shutdownState("The PRIMARY storage and the BACKUP storage don't have the same storage timestamp");
            return;
        }
        short myState = StateManager.removeSpecialFlags(this.m_state.m_currentState);
        switch (myState) {
            case 1: {
                this.handlePeerStateWhileWaiting(peerState, peerState.m_startActive);
                break;
            }
            case 3: {
                this.handlePeerStateWhileActiveClean(peerState, peerState.m_startActive);
                break;
            }
            case 2: {
                this.handlePeerStateWhileActiveDirty(peerState, peerState.m_startActive);
                break;
            }
            case 4: {
                this.handlePeerStateWhileStandby(peerState);
                break;
            }
            case 5: {
                this.handlePeerStateWhileSyncStandby(peerState);
                break;
            }
        }
        if (myState != StateManager.removeSpecialFlags(this.m_state.m_currentState)) {
            this.announceState(this.m_state);
        }
    }

    private synchronized void resetActivator() {
        if (this.m_activator != null) {
            this.m_activator.doNotActivate();
            this.m_activator = null;
        }
    }

    synchronized void communicationResumed() {
        Tracer.TRACE("StateManager.communicationResumed");
        this.resetActivator();
        this.m_peerAccessible = true;
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.announceState(this.m_state, true);
    }

    synchronized void communicationLost() {
        Tracer.TRACE("StateManager.communicationLost");
        this.resetActivator();
        this.m_peerAccessible = false;
        short myState = StateManager.removePrepareFlag(this.m_state.m_currentState);
        switch (myState) {
            case 1: {
                this.setState(this.thisWaitPeerLost());
                break;
            }
            case 4: {
                if (!this.m_storageController.allowedToGetActive()) break;
                this.m_activator = new Activator(this.m_detectionFailureTimeout, 1027);
                break;
            }
            case 5: {
                this.issueStateComment("Cannot turn active; need to synchronized with " + this.m_peerRole + ". Can be started with the start_active flag if the loss of updates can be tolerated");
                break;
            }
            case 517: {
                this.issueStateComment("Cannot turn active; need to copy the data (deep synchronization) from " + this.m_peerRole);
                break;
            }
        }
    }

    private void announceState(State newState) {
        this.announceState(newState, false);
    }

    private void issueStateComment(String comment) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ((IStateListener)this.m_listeners.get(i)).stateComment(comment);
        }
    }

    private void announceState(State newState, boolean toPeerOnly) {
        int i;
        Tracer.TRACE("StateManager.announceState " + newState + " toPeerOnly " + toPeerOnly);
        this.m_initialStateAnnounced = true;
        if (newState.m_currentState == 6) {
            for (i = 0; i < this.m_listeners.size(); ++i) {
                ((IStateListener)this.m_listeners.get(i)).preShutdown();
            }
        }
        for (i = 0; i < this.m_listeners.size(); ++i) {
            ((IStateListener)this.m_listeners.get(i)).newState(newState, toPeerOnly);
        }
    }

    private short thisWaitPeerLost() {
        switch (this.m_state.m_prevSessionState) {
            case 3: 
            case 4: {
                return 1027;
            }
            case 2: {
                return 1026;
            }
            case 5: {
                return 5;
            }
            case 517: {
                return 517;
            }
        }
        throw new Error("Prev session bad state when waiting while peer is lost  " + this.m_state.m_prevSessionState);
    }

    static short removePrepareFlag(short state) {
        return (short)(state & 0xFFFFFBFF);
    }

    private static short removeSpecialFlags(short state) {
        return (short)(state & 0xFFFFF9FF);
    }

    private void handlePeerStateWhileActiveClean(State peerState, boolean peerStartsActive) {
        if (peerStartsActive) {
            this.m_state.setShuttingdown("Shutting down since " + this.m_peerRole + " was started with the start_active flag");
            return;
        }
        int newState = 0;
        switch (peerState.m_currentState) {
            case 1: {
                this.announceState(this.m_state, true);
                break;
            }
            case 3: {
                if (this.m_thisPrimary || this.m_state.m_startActive) break;
                newState = this.replicationStable() ? 4 : 517;
                break;
            }
            case 2: {
                if (this.m_state.m_startActive) break;
                newState = this.replicationStable() ? 5 : 517;
                break;
            }
        }
        if (newState != 0) {
            this.m_state.setNewState((short)newState);
        }
    }

    private void handlePeerStateWhileActiveDirty(State peerState, boolean peerStartsActive) {
        if (peerStartsActive) {
            this.m_state.setShuttingdown("Shutting down since " + this.m_peerRole + " was started with the start_active flag");
            return;
        }
        int newState = 0;
        switch (peerState.m_currentState) {
            case 1: {
                this.announceState(this.m_state, true);
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                if (this.m_autoDualActiveResolve) {
                    if (this.m_thisPrimary) break;
                    if (this.m_state.m_startActive) {
                        this.m_state.setShuttingdown("Both PRIMARY and BACKUP contain unreplicated modifications. BACKUP was started active but must shutdown since dual-active-resolution is configured");
                        break;
                    }
                    newState = 517;
                    break;
                }
                this.m_state.setShuttingdown(BOTH_ACTIVE_ERROR_MSG);
                break;
            }
        }
        if (newState != 0) {
            this.m_state.setNewState((short)newState);
        }
    }

    private void handlePeerStateWhileStandby(State peerState) {
        short newState = 0;
        switch (peerState.m_currentState) {
            case 1: {
                this.announceState(this.m_state, true);
                break;
            }
            case 6: {
                if (!this.m_storageController.allowedToGetActive()) break;
                newState = 1027;
                break;
            }
            case 4: {
                if (!this.m_thisPrimary) break;
                newState = 1027;
                break;
            }
        }
        if (newState != 0) {
            this.m_state.setNewState(newState);
        }
    }

    private void handlePeerStateWhileSyncStandby(State peerState) {
        switch (peerState.m_currentState) {
            case 1: {
                this.announceState(this.m_state, true);
                break;
            }
            case 5: {
                this.m_state.setShuttingdown("Both PRIMARY and BACKUP are in a synchronizing standby state");
                break;
            }
        }
    }

    private void handlePeerStateWhileWaiting(State peerState, boolean peerStartsActive) {
        if (peerStartsActive) {
            int newState = this.m_state.m_prevSessionState == 3 && !this.replicationStable() ? 517 : (this.m_state.m_prevSessionState == 517 ? 517 : (this.m_state.m_prevSessionState == 2 ? 517 : (peerState.m_currentState == 3 ? 4 : 5)));
            this.m_state.setNewState((short)newState);
            return;
        }
        switch (peerState.m_currentState) {
            case 1: {
                this.thisWaitPeerWait(peerState, this.m_state);
                break;
            }
            case 2: 
            case 3: {
                this.thisWaitPeerActive(peerState, this.m_state);
                break;
            }
            case 4: 
            case 5: {
                this.thisWaitPeerStandby(peerState, this.m_state);
                break;
            }
            case 6: {
                this.thisWaitPeerShutdown(peerState, this.m_state);
            }
        }
    }

    private void thisWaitPeerWait(State peerState, State myState) {
        int newState = 0;
        switch (myState.m_prevSessionState) {
            case 3: {
                switch (peerState.m_prevSessionState) {
                    case 3: {
                        newState = this.m_thisPrimary ? 1027 : (this.replicationStable() ? 4 : 517);
                        break;
                    }
                    case 2: {
                        newState = this.replicationStable() ? 5 : 517;
                        break;
                    }
                    case 4: 
                    case 5: {
                        newState = 1027;
                    }
                }
                break;
            }
            case 2: {
                switch (peerState.m_prevSessionState) {
                    case 3: {
                        newState = 1026;
                        break;
                    }
                    case 2: {
                        if (this.m_autoDualActiveResolve) {
                            newState = this.m_thisPrimary ? 1026 : 517;
                            break;
                        }
                        myState.setShuttingdown(BOTH_ACTIVE_ERROR_MSG);
                        break;
                    }
                    case 4: 
                    case 5: {
                        newState = 1026;
                    }
                }
                break;
            }
            case 4: {
                switch (peerState.m_prevSessionState) {
                    case 3: {
                        newState = 4;
                        break;
                    }
                    case 2: {
                        newState = 5;
                        break;
                    }
                    case 4: {
                        newState = this.m_thisPrimary ? 1027 : 4;
                        break;
                    }
                    case 5: {
                        newState = 1027;
                    }
                }
                break;
            }
            case 5: {
                switch (peerState.m_prevSessionState) {
                    case 2: 
                    case 3: 
                    case 4: {
                        newState = 5;
                        break;
                    }
                    case 5: {
                        myState.setShuttingdown("Both PRIMARY and BACKUP are in a synchronizing standby state");
                    }
                }
                break;
            }
            case 517: {
                switch (peerState.m_prevSessionState) {
                    case 2: 
                    case 3: 
                    case 4: {
                        newState = 517;
                        break;
                    }
                    case 5: {
                        myState.setShuttingdown("Both PRIMARY and BACKUP are in a synchronizing standby state");
                    }
                }
                break;
            }
            default: {
                throw new Error("Prev session bad state when waiting  peer waiting " + myState.m_prevSessionState);
            }
        }
        if (newState != 0) {
            myState.setNewState((short)newState);
        }
    }

    private void thisWaitPeerActive(State peerState, State myState) {
        int newState = 0;
        switch (myState.m_prevSessionState) {
            case 3: {
                if (this.replicationStable()) {
                    newState = peerState.m_currentState == 3 ? 4 : 5;
                    break;
                }
                newState = 517;
                break;
            }
            case 2: {
                if (peerState.m_currentState == 3) {
                    newState = 1026;
                    break;
                }
                if (this.m_autoDualActiveResolve) {
                    newState = this.m_thisPrimary ? 1026 : 517;
                    break;
                }
                myState.setShuttingdown(BOTH_ACTIVE_ERROR_MSG);
                break;
            }
            case 4: 
            case 5: {
                newState = peerState.m_currentState == 3 ? 4 : 5;
                break;
            }
            case 517: {
                newState = 517;
                break;
            }
            default: {
                throw new Error("Prev session bad state when waiting peer active " + myState.m_prevSessionState);
            }
        }
        if (newState != 0) {
            myState.setNewState((short)newState);
        }
    }

    private void thisWaitPeerStandby(State peerState, State myState) {
        int newState = 0;
        switch (myState.m_prevSessionState) {
            case 3: {
                newState = 1027;
                break;
            }
            case 2: {
                newState = 1026;
                break;
            }
            case 4: {
                if (peerState.m_currentState == 4) {
                    newState = this.m_thisPrimary ? 1027 : 4;
                    break;
                }
                newState = 1027;
                break;
            }
            case 5: {
                if (peerState.m_currentState == 4) {
                    newState = 4;
                    break;
                }
                myState.setShuttingdown("Both PRIMARY and BACKUP are in a synchronizing standby state");
                break;
            }
            case 517: {
                newState = 517;
                break;
            }
            default: {
                throw new Error("Prev session bad state when waiting peer standby " + myState.m_prevSessionState);
            }
        }
        if (newState != 0) {
            myState.setNewState((short)newState);
        }
    }

    private boolean replicationStable() {
        return false;
    }

    private void thisWaitPeerShutdown(State peerState, State myState) {
        short newState = 0;
        switch (myState.m_prevSessionState) {
            case 3: {
                newState = 1027;
                break;
            }
            case 2: {
                newState = 1026;
                break;
            }
            case 4: {
                newState = 1027;
                break;
            }
            case 5: {
                newState = 5;
                break;
            }
            case 517: {
                newState = 517;
                break;
            }
            default: {
                throw new Error("Prev session bad state when waiting peer shutting down " + myState.m_prevSessionState);
            }
        }
        if (newState != 0) {
            myState.setNewState(newState);
        }
    }

    static class State {
        private static final String PREV_STATE = "PREV_STATE";
        private static final String PREV_SESSION_STATE = "PREV_SESSION_STATE";
        private static final String CURRENT_STATE = "CURRENT_STATE";
        private static final String START_ACTIVE = "START_ACTIVE";
        private static final String DB_TIMESTAMP = "DB_TIMESTAMP";
        private static final String SHUTDOWN_REASON = "SHUTDOWN_REASON";
        static final String TEMPORARY_CONNECTION = "TEMPORARY_CONNECTION";
        short m_currentState;
        short m_prevSessionState;
        short m_prevState;
        boolean m_startActive;
        long m_dbTimestamp;
        long m_peerDbTimestamp;
        String m_shutdownReason;
        Exception m_shutdownException;

        State(short currentState, short prevSessionState, boolean startActive, long dbTimestamp) {
            this.m_prevState = 0;
            this.m_currentState = currentState;
            this.m_prevSessionState = prevSessionState;
            this.m_startActive = startActive;
            this.m_dbTimestamp = dbTimestamp;
            this.m_shutdownReason = null;
            this.m_shutdownException = null;
        }

        State(HashMap map) {
            this.m_prevState = (Short)map.get(PREV_STATE);
            this.m_currentState = (Short)map.get(CURRENT_STATE);
            this.m_prevSessionState = (Short)map.get(PREV_SESSION_STATE);
            this.m_startActive = (Boolean)map.get(START_ACTIVE);
            this.m_dbTimestamp = (Long)map.get(DB_TIMESTAMP);
            this.m_shutdownReason = (String)map.get(SHUTDOWN_REASON);
        }

        void setShuttingdown(String reason) {
            this.m_shutdownReason = reason;
            this.setNewState((short)6);
        }

        void setShuttingdown(Exception e) {
            this.m_shutdownException = e;
            this.m_shutdownReason = e.toString();
            this.setNewState((short)6);
        }

        void setNewState(short newState) {
            if (newState != 6) {
                this.m_shutdownReason = null;
            }
            if (this.m_currentState == newState) {
                return;
            }
            this.m_prevState = this.m_currentState;
            this.m_currentState = newState;
            Tracer.TRACE("StateManager.m_state.setNewState " + this);
        }

        HashMap toHashmap(boolean temporaryConnection) {
            short currentStateToSend = StateManager.removeSpecialFlags(this.m_currentState);
            short prevStateToSend = StateManager.removeSpecialFlags(this.m_prevState);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(PREV_STATE, new Short(prevStateToSend));
            map.put(CURRENT_STATE, new Short(currentStateToSend));
            map.put(PREV_SESSION_STATE, new Short(this.m_prevSessionState));
            map.put(START_ACTIVE, new Boolean(this.m_startActive));
            map.put(DB_TIMESTAMP, new Long(this.m_dbTimestamp));
            if (this.m_shutdownReason != null) {
                map.put(SHUTDOWN_REASON, this.m_shutdownReason);
            }
            if (temporaryConnection) {
                map.put(TEMPORARY_CONNECTION, Boolean.TRUE);
            }
            return map;
        }

        public String toString() {
            return "state: " + State.getStateName(this.m_currentState) + " prev session state: " + State.getStateName(this.m_prevSessionState) + " prev state: " + State.getStateName(this.m_prevState);
        }

        static String getStateName(short stateNum) {
            switch (stateNum) {
                case 0: {
                    return "NO_STATE";
                }
                case 1: {
                    return "WAITING";
                }
                case 2: {
                    return "ACTIVE_DIRTY";
                }
                case 1026: {
                    return "PREPARING_ACTIVE_DIRTY";
                }
                case 3: {
                    return "ACTIVE_CLEAN";
                }
                case 1027: {
                    return "PREPARING_ACTIVE_CLEAN";
                }
                case 4: {
                    return "STANDBY_READY";
                }
                case 5: {
                    return "SYNCHRONIZING_STANDBY";
                }
                case 517: {
                    return "DEEP_SYNCHRONIZING_STANDBY";
                }
                case 6: {
                    return "SHUTTING_DOWN";
                }
            }
            throw new Error("Unknown state " + stateNum);
        }
    }

    private class CommHandler
    implements ICommunicationStatusHandler {
        private CommHandler() {
        }

        @Override
        public void permanentCommFailure(Exception e) {
            StateManager.this.shutdownState(e);
        }

        @Override
        public void connected(boolean ok) {
            if (ok && !StateManager.this.m_peerAccessible) {
                StateManager.this.communicationResumed();
            } else if (!ok && StateManager.this.m_peerAccessible) {
                StateManager.this.communicationLost();
            }
        }

        @Override
        public void reportException(String reporter, Exception e) {
        }

        @Override
        public void reportEvent(String event, boolean warning) {
        }
    }

    private class PeerStateHandler
    implements IMessageHandler {
        private PeerStateHandler() {
        }

        @Override
        public void handleMessage(HashMap msgProperties, byte[] data, int dataOffset, int dataLength) {
            throw new Error("The state manager should never get messages with data");
        }

        @Override
        public void handleMessage(HashMap msgProperties) {
            StateManager.this.peerStateChanged(msgProperties);
        }
    }

    private class Activator {
        boolean m_doActivate = true;
        short m_activeState;

        Activator(final int delayInSeconds, short activeState) {
            this.m_activeState = activeState;
            if (delayInSeconds == 0) {
                this.activate();
                return;
            }
            Thread activationThread = new Thread("State Manager Activation Thread"){

                @Override
                public void run() {
                    Activator.this.waitToActivate(delayInSeconds * 1000);
                    if (Activator.this.m_doActivate) {
                        Activator.this.activate();
                    }
                    StateManager.this.resetActivator();
                }
            };
            activationThread.setDaemon(true);
            activationThread.start();
        }

        private void activate() {
            StateManager.this.setState(this.m_activeState);
        }

        private synchronized void doNotActivate() {
            this.m_doActivate = false;
            this.notifyAll();
        }

        private synchronized void waitToActivate(long millis) {
            try {
                this.wait(millis);
            }
            catch (InterruptedException e) {
                this.m_doActivate = false;
                Tracer.TRACE(e);
            }
        }
    }
}

