/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.query.impl;

import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.VersionMisMatchException;
import com.sonicsw.mf.common.config.query.AttributeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public final class Util {
    public static void throwSerialVersionMismatch(int objectVersion, int classVersion) throws IOException {
        throw new IOException("Serialization version mismatch. Serialized object version: " + objectVersion + " class version: " + classVersion);
    }

    public static AttributeName removeFirstComponent(AttributeName name) {
        int count = name.getComponentCount();
        if (count == 0) {
            return null;
        }
        AttributeName result = new AttributeName();
        for (int i = 1; i < count; ++i) {
            Object component = name.getComponent(i);
            if (component instanceof String) {
                result.setNextComponent((String)component);
                continue;
            }
            result.setNextComponent((Integer)component);
        }
        return result;
    }

    public static void getReferenceChanges(IElement currentElement, IDeltaElement delta, ArrayList addedRefs, ArrayList modifiedRefs, ArrayList deletedRefs) throws VersionMisMatchException {
        IElement updatedElement = currentElement.createWritableClone();
        ((Element)updatedElement).doApplyDelta(delta);
        ArrayList currentRefList = new ArrayList();
        Util.findReferences(currentElement, currentRefList);
        ArrayList updatedRefList = new ArrayList();
        Util.findReferences(updatedElement, updatedRefList);
        for (AttributeName currentRefAttr : currentRefList) {
            if (updatedRefList.contains(currentRefAttr)) {
                if (updatedElement.getAttribute(currentRefAttr).equals(currentElement.getAttribute(currentRefAttr))) continue;
                modifiedRefs.add(currentRefAttr);
                continue;
            }
            deletedRefs.add(currentRefAttr);
        }
        for (AttributeName updatedRefAttr : updatedRefList) {
            if (currentRefList.contains(updatedRefAttr)) continue;
            addedRefs.add(updatedRefAttr);
        }
    }

    public static void findReferences(IElement element, ArrayList matchList) {
        Util.findReferences(element.getAttributes(), matchList, new AttributeName(element.getIdentity().getName(), true));
    }

    public static void findReferences(IAttributeSet attSet, ArrayList matchList, AttributeName myName) {
        HashMap map = attSet.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = map.get(key);
            if (value instanceof IAttributeSet) {
                Util.findReferences((IAttributeSet)value, matchList, myName.createClone().setNextComponent(key));
                continue;
            }
            if (value instanceof IAttributeList) {
                Util.findReferences((IAttributeList)value, matchList, myName.createClone().setNextComponent(key));
                continue;
            }
            if (!(value instanceof Reference)) continue;
            matchList.add(myName.createClone().setNextComponent(key));
        }
    }

    public static void findReferences(IAttributeList attList, ArrayList matchList, AttributeName myName) {
        for (int i = 0; i < attList.getCount(); ++i) {
            Object value = attList.getItem(i);
            if (value instanceof IAttributeSet) {
                Util.findReferences((IAttributeSet)value, matchList, myName.createClone().setNextComponent(i));
                continue;
            }
            if (value instanceof IAttributeList) {
                Util.findReferences((IAttributeList)value, matchList, myName.createClone().setNextComponent(i));
                continue;
            }
            if (!(value instanceof Reference)) continue;
            matchList.add(myName.createClone().setNextComponent(i));
        }
    }

    public static void findMatchingReferences(IElement element, Reference reference, ArrayList matchList) {
        Util.findMatchingReferences(element.getAttributes(), reference, matchList, new AttributeName(element.getIdentity().getName(), true));
    }

    public static void findMatchingReferences(IAttributeSet attSet, Reference reference, ArrayList matchList, AttributeName myName) {
        HashMap map = attSet.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = map.get(key);
            if (value instanceof IAttributeSet) {
                Util.findMatchingReferences((IAttributeSet)value, reference, matchList, myName.createClone().setNextComponent(key));
                continue;
            }
            if (value instanceof IAttributeList) {
                Util.findMatchingReferences((IAttributeList)value, reference, matchList, myName.createClone().setNextComponent(key));
                continue;
            }
            if (!(value instanceof Reference) || !((Reference)value).getElementName().equals(reference.getElementName())) continue;
            matchList.add(myName.createClone().setNextComponent(key));
        }
    }

    public static void findMatchingReferences(IAttributeList attList, Reference reference, ArrayList matchList, AttributeName myName) {
        for (int i = 0; i < attList.getCount(); ++i) {
            Object value = attList.getItem(i);
            if (value instanceof IAttributeSet) {
                Util.findMatchingReferences((IAttributeSet)value, reference, matchList, myName.createClone().setNextComponent(i));
                continue;
            }
            if (value instanceof IAttributeList) {
                Util.findMatchingReferences((IAttributeList)value, reference, matchList, myName.createClone().setNextComponent(i));
                continue;
            }
            if (!(value instanceof Reference) || !((Reference)value).getElementName().equals(reference.getElementName())) continue;
            matchList.add(myName.createClone().setNextComponent(i));
        }
    }
}

