/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.dirconfig;

import com.sonicsw.mf.common.runtime.IBackupStatus;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class BackupStatus
implements Serializable,
IBackupStatus {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 1;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        }
    };
    HashMap m_status = new HashMap();
    public static final String IN_PROGRESS = "IN_PROGRESS";
    public static final String START_TIME = "START_TIME";
    public static final String COMPLETION_TIME = "COMPLETION_TIME";
    public static final String LOCATION = "LOCATION";

    public BackupStatus() {
        this.m_status.put(IN_PROGRESS, Boolean.FALSE);
        this.m_status.put(START_TIME, new Long(-1L));
        this.m_status.put(COMPLETION_TIME, new Long(-1L));
        this.m_status.put(LOCATION, "");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(1);
        s.writeObject(this.m_status);
    }

    private void readObject(ObjectInputStream s) throws IOException {
        s.readInt();
        try {
            this.m_status = (HashMap)s.readObject();
        }
        catch (ClassNotFoundException notFound) {
            throw new IOException("Could not read BackupStatus: " + notFound.toString());
        }
    }

    public void startBackup(String backupLocation) {
        this.m_status.put(IN_PROGRESS, Boolean.TRUE);
        this.m_status.put(START_TIME, new Long(System.currentTimeMillis()));
        this.m_status.put(COMPLETION_TIME, new Long(-1L));
        this.m_status.put(LOCATION, backupLocation);
    }

    public void failBackup() {
        this.m_status.put(IN_PROGRESS, Boolean.FALSE);
        this.m_status.put(COMPLETION_TIME, new Long(-1L));
    }

    public void finishBackup() {
        this.m_status.put(IN_PROGRESS, Boolean.FALSE);
        this.m_status.put(COMPLETION_TIME, new Long(System.currentTimeMillis()));
    }

    @Override
    public boolean isInProgress() {
        return (Boolean)this.m_status.get(IN_PROGRESS);
    }

    @Override
    public long getStartTime() {
        return (Long)this.m_status.get(START_TIME);
    }

    @Override
    public long getCompletionTime() {
        return (Long)this.m_status.get(COMPLETION_TIME);
    }

    @Override
    public String getLocation() {
        return (String)this.m_status.get(LOCATION);
    }

    public String toString() {
        String statusString = this.getStartTime() == -1L ? "Start time: -1" : "Start time: " + DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.getStartTime()));
        statusString = statusString + ", location: " + this.getLocation();
        statusString = this.getCompletionTime() == -1L ? statusString + ", completion time: -1" : statusString + ", completion time: " + DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.getCompletionTime()));
        statusString = statusString + ", in progress: " + this.isInProgress();
        return statusString;
    }

    public void setInProgress(Boolean inProgress) {
        this.m_status.put(IN_PROGRESS, inProgress);
    }

    public void setStartTime(Long startTime) {
        this.m_status.put(START_TIME, startTime);
    }

    public void setCompletionTime(Long completionTime) {
        this.m_status.put(COMPLETION_TIME, completionTime);
    }

    public void setLocation(String location) {
        this.m_status.put(LOCATION, location);
    }
}

