/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import java.util.StringTokenizer;

public class CanonicalName
implements ICanonicalName {
    private String m_canonical;
    private String m_domain;
    private String m_container;
    private String m_component;
    private String m_nodeName;
    private String m_localContainerName;

    public CanonicalName(String canonicalName) {
        this.init(canonicalName);
    }

    public CanonicalName(String domain, String container, String component) {
        this.init(domain + "." + container + (component.length() == 0 ? "" : ":ID=" + component));
    }

    public final void init(String name) {
        this.m_canonical = name;
        StringTokenizer st = new StringTokenizer(name, ".:");
        this.m_domain = st.nextToken();
        this.m_container = st.nextToken();
        String string = this.m_component = st.hasMoreTokens() ? st.nextToken() : "";
        if (this.m_component.length() > 0) {
            this.m_component = this.m_component.substring(IComponentIdentity.ID_PREFIX_LENGTH);
        }
        CompoundContainerName compoundName = new CompoundContainerName(this.m_container);
        this.m_nodeName = compoundName.m_nodeName;
        this.m_localContainerName = compoundName.m_localContainerName;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    public String getLocalContainerName() {
        return this.m_localContainerName;
    }

    @Override
    public String getCanonicalName() {
        return this.m_canonical;
    }

    @Override
    public String getDomainName() {
        return this.m_domain;
    }

    @Override
    public String getContainerName() {
        return this.m_container;
    }

    @Override
    public String getComponentName() {
        return this.m_component;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ICanonicalName)) {
            return false;
        }
        return this.m_canonical.equals(((ICanonicalName)object).getCanonicalName());
    }

    public int hashCode() {
        return this.m_canonical.hashCode();
    }

    @Override
    public int compareTo(Object object) throws ClassCastException {
        return this.m_canonical.compareTo(((CanonicalName)object).getCanonicalName());
    }

    static class CompoundContainerName {
        private static final char NODE_AT_CHAR = '@';
        String m_localContainerName;
        String m_nodeName;

        CompoundContainerName(String containerName) {
            int nodeDelimiter = containerName.indexOf(64);
            if (nodeDelimiter != -1) {
                this.m_localContainerName = containerName.substring(0, nodeDelimiter);
                this.m_nodeName = containerName.substring(nodeDelimiter + 1);
            } else {
                this.m_localContainerName = containerName;
                this.m_nodeName = "";
            }
        }
    }
}

