/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.runtime.IChildContainerState;
import com.sonicsw.mf.common.runtime.IContainerExitCodes;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;

public class ChildContainerState
implements IChildContainerState,
Serializable {
    private static final long serialVersionUID = -7773691032575402133L;
    private static final short m_serialVersion = 0;
    private IContainerIdentity m_containerID;
    private long m_timestamp;
    private short m_state = 0;
    private Integer m_exitCode;
    private ArrayList m_logTail = new ArrayList();
    private static final int MAX_LOG_TAIL_SIZE = 200;

    public ChildContainerState(CanonicalName canonicalName, IElementIdentity configID) {
        this.m_containerID = new ContainerIdentity(canonicalName, configID);
        this.m_timestamp = System.currentTimeMillis();
    }

    @Override
    public IIdentity getRuntimeIdentity() {
        return this.m_containerID;
    }

    @Override
    public long getTimeStamp() {
        return this.m_timestamp == 0L ? System.currentTimeMillis() : this.m_timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    @Override
    public short getState() {
        return this.m_state;
    }

    public void setState(short state) {
        if (state != 0 && state != 3 && state != 2 && state != 1) {
            throw new IllegalArgumentException("Invalid container state: " + state);
        }
        this.m_state = state;
    }

    @Override
    public String getStateString() {
        return IChildContainerState.STATE_TEXT[this.getState()];
    }

    public synchronized void setExitCode(short exitCode) {
        if (exitCode < 0 || exitCode > IContainerExitCodes.EXIT_CODE_TEXTS.length - 1) {
            throw new IllegalArgumentException("Invalid container exit code: " + exitCode);
        }
        this.m_exitCode = new Integer(exitCode);
    }

    public void clearExitCode() {
        this.m_exitCode = null;
    }

    @Override
    public Integer getExitCode() {
        return this.m_exitCode;
    }

    public synchronized void addLogLine(String logLine) {
        while (this.m_logTail.size() > 200) {
            this.m_logTail.remove(0);
        }
        this.m_logTail.add(logLine);
    }

    @Override
    public String[] getLogTail() {
        return this.m_logTail.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    public String toString() {
        return this.getStateString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IChildContainerState)) {
            return false;
        }
        return this.getRuntimeIdentity().equals(((IChildContainerState)object).getRuntimeIdentity()) && this.getState() == ((IChildContainerState)object).getState();
    }

    public int hashCode() {
        return Objects.hash(this.getRuntimeIdentity(), this.getState());
    }

    @Override
    public int compareTo(Object object) throws ClassCastException {
        return this.toString().compareTo(((IChildContainerState)object).toString());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(6);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("containerID");
        stream.writeObject(this.m_containerID);
        stream.writeUTF("timestamp");
        stream.writeObject(new Long(System.currentTimeMillis()));
        stream.writeUTF("state");
        stream.writeObject(new Short(this.m_state));
        stream.writeUTF("exitCode");
        stream.writeObject(this.m_exitCode);
        stream.writeUTF("logTail");
        stream.writeObject(this.m_logTail);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_containerID = (IContainerIdentity)map.get("containerID");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_timestamp = (Long)map.get("timestamp");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_state = (Short)map.get("state");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_exitCode = (Integer)map.get("exitCode");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.m_logTail = (ArrayList)map.get("logTail");
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

