/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.url;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.url.SonicRNURL;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class SonicRNStreamHandler
extends URLStreamHandler {
    private IDirectoryAdminService m_ds;
    private boolean m_local = true;

    public SonicRNStreamHandler(IDirectoryAdminService ds, boolean local) {
        this.m_ds = ds;
        this.m_local = true;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    public void setDirectoryService(IDirectoryAdminService ds) {
        this.m_ds = ds;
    }

    public class Connection
    extends URLConnection {
        private Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public Object getContent() throws IOException {
            try {
                SonicRNURL sonicrnURL = new SonicRNURL(this.url);
                return SonicRNStreamHandler.this.m_local ? sonicrnURL.resolveURL(SonicRNStreamHandler.this.m_ds) : "";
            }
            catch (Exception dirE) {
                IOException ioE = new IOException("Unable to resolve " + this.url);
                ioE.initCause(dirE);
                throw ioE;
            }
        }

        @Override
        public String getContentType() {
            return "application/octet-stream";
        }

        @Override
        public boolean getUseCaches() {
            return false;
        }
    }
}

