/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LockFile {
    private File m_lockFile;
    private File m_processFile;
    private RandomAccessFile m_raf;
    private Object m_fileLock;
    private static boolean m_canUseNIO = false;
    private static boolean m_isWindowsOS;

    public LockFile(String path) {
        this.m_lockFile = new File(path);
        this.m_processFile = new File(path + ".tmp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean lock() {
        if (this.m_raf != null) {
            return true;
        }
        if (m_isWindowsOS) {
            try {
                if (this.m_processFile.exists()) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.m_processFile.createNewFile()) {
                    boolean bl = false;
                    return bl;
                }
                this.m_lockFile.delete();
                if (this.m_lockFile.exists()) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.m_lockFile.createNewFile()) {
                    boolean bl = false;
                    return bl;
                }
                this.m_raf = new RandomAccessFile(this.m_lockFile, "rw");
                boolean e = true;
                return e;
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.m_processFile.delete();
            }
        }
        if (m_canUseNIO) {
            try {
                this.m_raf = new RandomAccessFile(this.m_lockFile, "rw");
                Class<RandomAccessFile> rafClass = RandomAccessFile.class;
                try {
                    Method getChannelMethod = rafClass.getMethod("getChannel", new Class[0]);
                    Object channel = getChannelMethod.invoke((Object)this.m_raf, new Object[0]);
                    Class<?> channelClass = channel.getClass();
                    Method getLockMethod = channelClass.getMethod("tryLock", new Class[0]);
                    this.m_fileLock = getLockMethod.invoke(channel, new Object[0]);
                    boolean bl = this.m_fileLock != null;
                    return bl;
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof IOException)) {
                        e.getTargetException().printStackTrace();
                    }
                    boolean bl = false;
                    if (this.m_fileLock == null) {
                        this.cleanup();
                    }
                    return bl;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    boolean bl = false;
                    if (this.m_fileLock == null) {
                        this.cleanup();
                    }
                    return bl;
                    {
                        catch (FileNotFoundException e2) {
                            e2.printStackTrace();
                            boolean bl2 = false;
                            return bl2;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                if (this.m_fileLock == null) {
                    this.cleanup();
                }
            }
        }
        try {
            return this.m_lockFile.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock() {
        if (m_isWindowsOS) {
            while (true) {
                try {
                    if (!this.m_processFile.exists() && this.m_processFile.createNewFile()) {
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    this.wait(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.cleanup();
            }
            finally {
                this.m_lockFile.delete();
                this.m_processFile.delete();
            }
        }
        try {
            this.cleanup();
        }
        finally {
            this.m_lockFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        try {
            if (this.m_fileLock != null) {
                Class<?> fileLockClass = this.m_fileLock.getClass();
                try {
                    Method releaseMethod = fileLockClass.getMethod("release", new Class[0]);
                    releaseMethod.invoke(this.m_fileLock, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (this.m_raf != null) {
                    this.m_raf.close();
                    this.m_raf = null;
                }
            }
            catch (IOException iOException) {}
            this.m_fileLock = null;
        }
    }

    static {
        try {
            Class<?> fileLockClass = Class.forName("java.nio.channels.FileLock");
            m_canUseNIO = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        m_isWindowsOS = File.pathSeparatorChar == ';';
    }
}

