/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.view.ILink;
import com.sonicsw.mf.common.view.IViewElementAttributes;
import com.sonicsw.mf.common.view.impl.ViewConstants;
import com.sonicsw.mf.common.view.impl.ViewElementAttributes;
import java.util.HashMap;

public class Link
implements ILink {
    private IAttributeSet m_attrSet = null;
    private IAttributeSetType m_attrLinkType = null;
    private String m_linkedObjectName = null;
    private ViewElementAttributes m_attributes = null;
    private String m_name = null;

    Link(IAttributeSet parent, IAttributeSetType attrSetType, String name, String linkedObjectName, boolean complex) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        this.m_name = name;
        this.m_attrSet = (IAttributeSet)parent.getAttribute(name.toLowerCase());
        if (this.m_attrSet == null && System.getProperty("MQ_UPGRADE", "false").equals("true")) {
            this.m_attrSet = (IAttributeSet)parent.getAttribute(name);
        }
        if (this.m_attrSet == null) {
            this.m_attrSet = parent.createAttributeSet(name.toLowerCase());
            this.m_attrSet.createAttributeList(ViewConstants.ATTRS_VALUES);
            this.m_attrSet.setStringAttribute(ViewConstants.ATTR_LINKOBJECT, linkedObjectName);
            this.m_attrSet.setIntegerAttribute(ViewConstants.TYPE_ATTR, ViewConstants.LINK_TYPE);
            this.m_attrSet.setStringAttribute(ViewConstants.ORIGINAL_NAME, name);
            if (complex) {
                this.m_attrSet.setBooleanAttribute(ViewConstants.ATTR_COMPLEX_LINK, Boolean.TRUE);
            }
        }
        this.m_attrLinkType = attrSetType;
        this.m_linkedObjectName = linkedObjectName;
        this.setAttributes();
    }

    @Override
    public String getLinkedObjectName() {
        return (String)this.m_attrSet.getAttribute(ViewConstants.ATTR_LINKOBJECT);
    }

    @Override
    public void setComplex() throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        this.m_attrSet.setBooleanAttribute(ViewConstants.ATTR_COMPLEX_LINK, Boolean.TRUE);
    }

    @Override
    public void setComplexAttributes(HashMap attributes) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        IAttributeSet attSet = this.m_attrSet.createAttributeSet(ViewConstants.ATTR_COMPLEX_ATTRIBUTES);
        for (String key : attributes.keySet()) {
            Object valObject = attributes.get(key);
            if (!(valObject instanceof String)) {
                throw new AttributeSetTypeException("Meta attributes must be of type java.lang.String.");
            }
            String value = (String)valObject;
            attSet.setStringAttribute(key, value);
        }
    }

    @Override
    public HashMap getComplexAttributes() {
        IAttributeSet set = (IAttributeSet)this.m_attrSet.getAttribute(ViewConstants.ATTR_COMPLEX_ATTRIBUTES);
        if (set == null) {
            return new HashMap();
        }
        return set.getAttributes();
    }

    @Override
    public boolean isComplex() {
        Boolean complex = (Boolean)this.m_attrSet.getAttribute(ViewConstants.ATTR_COMPLEX_LINK);
        return complex != null && complex != false;
    }

    @Override
    public IViewElementAttributes getAttributes() {
        return this.m_attributes;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    private void setAttributes() {
        this.m_attributes = new ViewElementAttributes();
        this.m_attributes.setAttributeNamesList(this.m_attrLinkType.getAttributeNames());
        this.m_attributes.setAttributeValuesList((IAttributeList)this.m_attrSet.getAttribute(ViewConstants.ATTRS_VALUES));
    }
}

