package com.sonicsw.jmx.remote.protocol.sonic.ssl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;

import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;

import com.sonicsw.jmx.remote.sonic.SonicConnector;

public class ClientProvider
implements JMXConnectorProvider
{
    @Override
    public JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map environment)
    throws IOException
    {
        if (!serviceURL.getProtocol().equals("sonic+ssl"))
        {
            throw new MalformedURLException("Protocol not sonic+ssl: " + serviceURL.getProtocol());
        }

        return new SonicConnector(serviceURL, environment);
    }
}
