package com.sonicsw.jmx.remote.sonic;

import java.io.IOException;
import java.util.Set;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

import com.sonicsw.mf.jmx.client.JMSConnectorClient;

/**
 * This object delegates all remote calls to the Sonic specific JMSConnectorClient.
 */
public class SonicConnection
implements MBeanServerConnection
{
    private JMSConnectorClient m_jmsConnectorClient;

    SonicConnection(JMSConnectorClient jmsConnectorClient)
    {
        m_jmsConnectorClient = jmsConnectorClient;
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
    throws InstanceNotFoundException, IOException
    {
        try
        {
            m_jmsConnectorClient.addNotificationListener(name, listener, filter, handback);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to add notification listener", e);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)
    throws InstanceNotFoundException, IOException
    {
        throw new IOException("Method not supported in this version");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name)
    throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException
    {
        try
        {
            return m_jmsConnectorClient.createMBean(className, name);
        }
        catch (ReflectionException e) { throw e; }
        catch (InstanceAlreadyExistsException e) { throw e; }
        catch (MBeanRegistrationException e) { throw e; }
        catch (MBeanException e) { throw e; }
        catch (NotCompliantMBeanException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to create MBean", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName)
    throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException
    {
        try
        {
            return m_jmsConnectorClient.createMBean(className, name, loaderName);
        }
        catch (ReflectionException e) { throw e; }
        catch (InstanceAlreadyExistsException e) { throw e; }
        catch (MBeanRegistrationException e) { throw e; }
        catch (MBeanException e) { throw e; }
        catch (NotCompliantMBeanException e) { throw e; }
        catch (InstanceNotFoundException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to create MBean", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object params[], String signature[])
    throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException
    {
        try
        {
            return m_jmsConnectorClient.createMBean(className, name, params, signature);
        }
        catch (ReflectionException e) { throw e; }
        catch (InstanceAlreadyExistsException e) { throw e; }
        catch (MBeanRegistrationException e) { throw e; }
        catch (MBeanException e) { throw e; }
        catch (NotCompliantMBeanException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to create MBean", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object params[], String signature[])
    throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException
    {
        try
        {
            return m_jmsConnectorClient.createMBean(className, name, loaderName, params, signature);
        }
        catch (ReflectionException e) { throw e; }
        catch (InstanceAlreadyExistsException e) { throw e; }
        catch (MBeanRegistrationException e) { throw e; }
        catch (MBeanException e) { throw e; }
        catch (NotCompliantMBeanException e) { throw e; }
        catch (InstanceNotFoundException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to create MBean", e);
        }
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute)
    throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException
    {
        try
        {
            return m_jmsConnectorClient.getAttribute(name, attribute);
        }
        catch (MBeanException e) { throw e; }
        catch (AttributeNotFoundException e) { throw e; }
        catch (InstanceNotFoundException e) { throw e; }
        catch (ReflectionException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to get attribute", e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes)
    throws InstanceNotFoundException, ReflectionException, IOException
    {
        try
        {
            return m_jmsConnectorClient.getAttributes(name, attributes);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (ReflectionException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to get attributes", e);
        }
    }

    @Override
    public String getDefaultDomain()
    throws IOException
    {
        try
        {
            return m_jmsConnectorClient.getDefaultDomain();
        }
        catch (Throwable e)
        {
            throw new IOException("Failed to get defaul domain", e);
        }
    }

    @Override
    public String[] getDomains()
    throws IOException
    {
        throw new IOException("Method not supported in this version");
    }

    @Override
    public Integer getMBeanCount()
    throws IOException
    {
        try
        {
            return m_jmsConnectorClient.getMBeanCount();
        }
        catch (Throwable e)
        {
            throw new IOException("Failed to get MBean count", e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name)
    throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException
    {
        try
        {
            return m_jmsConnectorClient.getMBeanInfo(name);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (IntrospectionException e) { throw e; }
        catch (ReflectionException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to get MBeanInfo", e);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name)
    throws InstanceNotFoundException, IOException
    {
        try
        {
            return m_jmsConnectorClient.getObjectInstance(name);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to get object instance", e);
        }
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object params[], String signature[])
    throws InstanceNotFoundException, MBeanException, ReflectionException, IOException
    {
        try
        {
            return m_jmsConnectorClient.invoke(name, operationName, params, signature);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (MBeanException e) { throw e; }
        catch (ReflectionException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to invoke operation", e);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className)
    throws InstanceNotFoundException, IOException
    {
        try
        {
            return m_jmsConnectorClient.isInstanceOf(name, className);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to check is instance of", e);
        }
    }

    @Override
    public boolean isRegistered(ObjectName name)
    throws IOException
    {
        try
        {
            return m_jmsConnectorClient.isRegistered(name);
        }
        catch (Throwable e)
        {
            throw new IOException("Failed to check if registered", e);
        }
    }

    @Override
    public Set queryMBeans(ObjectName name, QueryExp query)
    throws IOException
    {
        try
        {
            return m_jmsConnectorClient.queryMBeans(name, query);
        }
        catch (Throwable e)
        {
            throw new IOException("Failed to query MBeans", e);
        }
    }

    @Override
    public Set queryNames(ObjectName name, QueryExp query)
    throws IOException
    {
        try
        {
            return m_jmsConnectorClient.queryNames(name, query);
        }
        catch (Throwable e)
        {
            throw new IOException("Failed to query MBean names", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener)
    throws InstanceNotFoundException, ListenerNotFoundException, IOException
    {
        try
        {
            m_jmsConnectorClient.removeNotificationListener(name, listener);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (ListenerNotFoundException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to remove notification listener", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback)
    throws InstanceNotFoundException, ListenerNotFoundException, IOException
    {
        try
        {
            m_jmsConnectorClient.removeNotificationListener(name, listener, filter, handback);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (ListenerNotFoundException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to remove notification listener", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener)
    throws InstanceNotFoundException, ListenerNotFoundException, IOException
    {
        throw new IOException("Method not supported in this version");
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback)
    throws InstanceNotFoundException, ListenerNotFoundException, IOException
    {
        throw new IOException("Method not supported in this version");
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute)
    throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException
    {
        try
        {
            m_jmsConnectorClient.setAttribute(name, attribute);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (AttributeNotFoundException e) { throw e; }
        catch (InvalidAttributeValueException e) { throw e; }
        catch (MBeanException e) { throw e; }
        catch (ReflectionException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to set attribute", e);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes)
    throws InstanceNotFoundException, ReflectionException, IOException
    {
        try
        {
            return m_jmsConnectorClient.setAttributes(name, attributes);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (ReflectionException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to set attributes", e);
        }
    }

    @Override
    public void unregisterMBean(ObjectName name)
    throws InstanceNotFoundException, MBeanRegistrationException, IOException
    {
        try
        {
            m_jmsConnectorClient.unregisterMBean(name);
        }
        catch (InstanceNotFoundException e) { throw e; }
        catch (MBeanRegistrationException e) { throw e; }
        catch (Throwable e)
        {
            throw new IOException("Failed to unregister MBean", e);
        }
    }
}
