package com.sonicsw.jndi.mfcontext;


import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public final class MFContextFactory implements InitialContextFactory
{
    public MFContextFactory() { }

    /**
     * See {@link #InitialContextFactory.getInitialContext(Hashtable env)} for details.
     */
    @Override
    public Context getInitialContext(Hashtable env)
    throws NamingException
    {
        // get the primary connection URLs and the initial context
        String providerURL = (String)env.get(Context.PROVIDER_URL);
        
        // extract params from URL .. params will override any env settings since they are on a specific
        // URL basis
        HashMap params = extractParams(providerURL);
        
        if (params.containsKey("domain"))
        {
            env.put(MFContext.DOMAIN, params.get("domain"));
        }
        
        if (params.containsKey("connectTimeout"))
        {
            env.put(MFContext.CONNECT_TIMEOUT, params.get("connectTimeout"));
        }
        
        if (params.containsKey("idleTimeout"))
        {
            env.put(MFContext.IDLE_TIMEOUT, params.get("idleTimeout"));
        }
        
        if (params.containsKey("requestTimeout"))
        {
            env.put(MFContext.REQUEST_TIMEOUT, params.get("requestTimeout"));
        }
        
        if (params.containsKey("lookupRetries"))
        {
            env.put(MFContext.LOOKUP_RETRIES, params.get("lookupRetries"));
        }
        
        if (params.containsKey("socketTimeout"))
        {
            env.put(MFContext.SOCKET_CONNECT_TIMEOUT, params.get("socketTimeout"));
        }
        
        if (params.containsKey("node"))
        {
            env.put(MFContext.NODE, params.get("node"));
        }
        
        StringBuffer connectionURLs = new StringBuffer();
        String initialCtxName = getConnectionURLs(providerURL, connectionURLs);  // connection URLs will be returned in "connectionURLS" StringBuffer object

        // create the context object and return it
        Context root = new MFContext(connectionURLs.toString(), initialCtxName, env);
        return root;
    }

    private HashMap extractParams(String providerURL)
    {
        HashMap params = new HashMap();
        
        if (providerURL == null || providerURL.length() == 0)
        {
            return params;
        }
        
        // the provider URL could be a list in which case we will look for the params in the first URL in the list
        StringTokenizer st = new StringTokenizer(providerURL, ", ");
        
        String firstURL = st.nextToken();
        
        if (!firstURL.contains("?"))
        {
            return params;
        }
        
        st = new StringTokenizer(firstURL, "?");
        st.nextToken(); // ignore the first (its the Sonic URL)
        
        st = new StringTokenizer(st.nextToken(), "=&");
        while (st.hasMoreTokens())
        {
            params.put(st.nextToken(), st.nextToken());
        }
        
        return params;
    }

    private String getConnectionURLs( String providerURL, StringBuffer connectionURLs ) throws javax.naming.NamingException
    {
        String initialCtxName = null;

        if (providerURL == null || providerURL.length() == 0)
        {
            connectionURLs.append("tcp://localhost:2506");
            initialCtxName = "";
        }
        else
        {
            StringTokenizer st = new StringTokenizer(providerURL, ", ");
            while (st.hasMoreTokens())
            {
                String connectionURL = st.nextToken();
                String ctxName = "";

                int ctxSearchStartPosn = connectionURL.indexOf("//");
                ctxSearchStartPosn += (ctxSearchStartPosn == -1 ? 1 : 2);

                int ctxPosn = connectionURL.indexOf("/", ctxSearchStartPosn);
                if (ctxPosn >= 0) // i.e. there is an intial sub context we should go to
                {
                    ctxName = connectionURL.substring(ctxPosn + 1);
                    
                    // remove any parameters
                    if (ctxName.indexOf('?') > 0)
                    {
                        ctxName = ctxName.substring(0, ctxName.indexOf('?'));
                    }
                    
                    // reset the connectionURL
                    connectionURL = connectionURL.substring(0, ctxPosn);
                }

                if (initialCtxName == null)
                {
                    initialCtxName = ctxName;
                }
                else
                if (!ctxName.equals(initialCtxName))
                {
                    throw new NamingException("When specifying multiple URLs, each URL must specify the same context.");
                }

                if (connectionURLs.length() > 0)
                {
                    connectionURLs.append(',');
                }

                // remove any parameters
                if (connectionURL.indexOf('?') > 0)
                {
                    connectionURL = connectionURL.substring(0, connectionURL.indexOf('?'));
                }

                connectionURLs.append(connectionURL);
            }
        }

        return initialCtxName;
    }
}
