/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.event.MenuEvent;

import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.gui.util.MenuScroller;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;

/**
 * Context sensitive "Action" menu
 */
final class ActionMenu
    extends JBasicMenu
{
    private PreferenceManager m_preferences;

    private JBasicMenu m_connectMenu;
    private JBasicMenuItem m_newConnectionMenuItem;
    private JBasicMenuItem m_disconnectMenuItem;
    private JBasicMenuItem m_exitMenuItem;

    ActionMenu(PreferenceManager preferences, MouseListener mouseListener)
    {
        super(new FileAction());

        m_preferences = preferences;

        m_connectMenu = new JBasicMenu(new FileConnectAction());
        m_newConnectionMenuItem = new JBasicMenuItem(new NewConnectionAction());
        m_exitMenuItem = new JBasicMenuItem(new ExitAction());
        m_disconnectMenuItem = new JBasicMenuItem(new DisconnectAction());

        MenuScroller.setScrollerFor(m_connectMenu, 25, 125, 1, 0);
        
        setMouseListener(mouseListener);

        buildMenu(null);
    }

    @Override
    public void menuSelected(MenuEvent evt)
    {
        JInternalFrame innerFrame = MgmtConsole.getMgmtConsole().getDesktopPane().getSelectedFrame();

        if (innerFrame != null && innerFrame instanceof IWorkspaceWindow)
        {
            buildMenu((IWorkspaceWindow) innerFrame);
        }
        else
        {
            buildMenu(null);
        }

        super.menuSelected(evt);
    }

    private void buildMenu(IWorkspaceWindow window)
    {
        removeAll();

        add(getConnectMenu());

        if (window != null)
        {
            add(m_disconnectMenuItem);
            addSeparator();

            JComponent[] newItems = window.getSelectedMenuItems(IPlugin.NEW_TYPE);
            JComponent[] pluginItems = window.getSelectedMenuItems(IPlugin.PLUGIN_TYPE);
            JComponent[] systemItems = window.getSelectedMenuItems(IPlugin.SYSTEM_TYPE);
            JComponent[] propertyItems = window.getSelectedMenuItems(IPlugin.PROPERTIES_TYPE);

            if (newItems != null && newItems.length > 0)
            {
                for (int i = 0; i < newItems.length; i++)
                {
                    add(newItems[i]);
                }

                addSeparator();
            }

            if (pluginItems != null && pluginItems.length > 0)
            {
                for (int i = 0; i < pluginItems.length; i++)
                {
                    add(pluginItems[i]);
                }

                addSeparator();
            }

            if (systemItems != null && systemItems.length > 0)
            {
                for (int i = 0; i < systemItems.length; i++)
                {
                    add(systemItems[i]);
                }

                addSeparator();
            }

            if (propertyItems != null && propertyItems.length > 0)
            {
                for (int i = 0; i < propertyItems.length; i++)
                {
                    add(propertyItems[i]);
                }

                addSeparator();
            }
        }
        else
        {
            addSeparator();
        }

        add(m_exitMenuItem);
    }

    private JComponent getConnectMenu()
    {
        m_connectMenu.removeAll();

        m_connectMenu.add(m_newConnectionMenuItem);

        String[] children = m_preferences.getChildrenNames("connections");

        ArrayList list = DomainConnectionModel.getFirstN(m_preferences);

        if (!list.isEmpty())
        {
            m_connectMenu.addSeparator();
        }

        for (int i = 0; i < list.size(); i++)
        {
            DomainConnectionModel connectionModel =
                new DomainConnectionModel(m_preferences, (String) list.get(i));

            JBasicMenuItem mi = new JBasicMenuItem(new ConnectAction(i + 1, connectionModel));
            mi.setIcon(ResourceManager.getIcon(getClass(), "Connect"));
            m_connectMenu.add(mi);
        }
        return m_connectMenu;
    }

    Action getExitAction()
    {
        return m_exitMenuItem.getAction();
    }

    Action getDisconnectAction()
    {
        return m_disconnectMenuItem.getAction();
    }

    //-------------------------------------------------------------------------
    //
    // Inner classes
    //
    //-------------------------------------------------------------------------

    static class FileAction
        extends BasicGuiAction
    {
        public FileAction()
        {
            super("file");
        }
    }

    class FileConnectAction
        extends BasicGuiAction
    {
        public FileConnectAction()
        {
            super("file.connect");
        }
    }

    private final class ExitAction
        extends BasicGuiAction
    {
        public ExitAction()
        {
            super("file.exit");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            MgmtConsole.getMgmtConsole().windowClosing(null);
        }
    }

    private final class NewConnectionAction
        extends BasicGuiAction
    {
        public NewConnectionAction()
        {
            super("file.connect.new");

            putValue(Action.SMALL_ICON, new ExtendedImageIcon((Icon) getValue(Action.SMALL_ICON), ResourceManager.getIcon(getClass(), "newoverlay")));
        }

        @Override
        public void actionPerformed(ActionEvent event)
        {
            MgmtConsole.getMgmtConsole().connectToDomain(null);
        }
    }

    private final class ConnectAction
        extends BasicGuiAction
    {
        private DomainConnectionModel connectionModel;

        public ConnectAction(int index, DomainConnectionModel connectionModel)
        {
            super("file.connect.previous");

            this.connectionModel = connectionModel;

            putValue(Action.NAME, index + " - " + connectionModel.getDomainDescription());
        }

        @Override
        public void actionPerformed(ActionEvent event)
        {
            MgmtConsole.getMgmtConsole().connectToDomain(this.connectionModel);
        }
    }

    private final class DisconnectAction
        extends BasicGuiAction
    {
        public DisconnectAction()
        {
            super("file.disconnect");

            putValue(Action.SMALL_ICON, new ExtendedImageIcon(ResourceManager.getIcon(getClass(), "Connect"), ResourceManager.getIcon(getClass(), "deleteoverlay")));
        }

        @Override
        public void actionPerformed(ActionEvent event)
        {
            MgmtConsole.getMgmtConsole().disconnect();
        }
    }
}