/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import modelobjects.util.CommonEventSupport;

public class ApplicationListenerSupport extends CommonEventSupport
{
    public ApplicationListenerSupport()
    {
        super();
    }

    public void addApplicationListener(ApplicationListener listener)
    {
        addEventListener(listener);
    }

    public void removeApplicationListener(ApplicationListener listener)
    {
        removeEventListener(listener);
    }

    public void fireApplicationLowOnMemory(Object eventSource)
    {
        if (anyListeners())
        {
            ApplicationEvent event = new ApplicationEvent(eventSource, ApplicationEvent.MEMORY_LOW);
            fireEvent(ApplicationListener.class, "applicationLowOnMemory", event);
        }
    }

    public void fireApplicationShuttingDown(Object eventSource)
    throws ShutDownCancelledException
    {
        if (anyListeners())
        {
            ApplicationEvent event = new ApplicationEvent(eventSource, ApplicationEvent.SHUTTING_DOWN);

            try
            {
                fireEvent(ApplicationListener.class,
                          "applicationShuttingDown",
                          event,
                          ShutDownCancelledException.class);
            }
            catch (ShutDownCancelledException cancel)
            {
                throw cancel;
            }
            catch (RuntimeException bug)
            {
                throw bug;
            }
            catch (Throwable other)
            {
                throw new RuntimeException("Unexpected exception: " + other, other);
            }
        }
    }
}
