/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

import com.sonicsw.mf.common.config.IElementIdentity;

public class DeveloperDebug
{
    /*
    public static final Set hardcodeMetaAttributes(Set set, String path)
    {
        Iterator i = set.iterator();

        while (i.hasNext())
            hardcodeMetaAttributes((HashMap)i.next());

        return set;
    }
    */

    public static final IElementIdentity createElementIdentity(String path)
    {
        return new DebugElementIdentity(path);
    }

    /*
    public static final Map hardcodeMetaAttributes(Map map)
    {
        String folderName = (String)map.get(IConfigServer.FOLDER_NAME);

        if (folderName != null)
        {
            if (folderName.equals("/Security/Default Authentication"))
            {
                map.put(ConfigServerUtility.TYPE, com.sonicsw.ma.gui.config.security.AuthenticationDomainPluginFactory.PLUGIN_TYPE);
                map.put(ConfigServerUtility.PRODUCT_VERSION, "2.0");
                map.put(ConfigServerUtility.CONFIG_VERSION,  "2.0");
            }

            return map;
        }

        IElementIdentity id = (IElementIdentity)map.get(IConfigServer.ELEMENT_IDENTITY);

        if (id == null)
            return map;

        System.out.println("id = " + id.getName());

        //if (id.getName().equals("/directory/0"))
        if (id.getName().equals("/Framework Components/DIRECTORY SERVICE"))
        {
            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_DIRECTORY_SERVICE");
            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "2.0");
            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "2.0");
        }

        //if (id.getName().equals("/manager/0"))
        if (id.getName().equals("/Framework Components/AGENT MANAGER"))
        {
            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_AGENT_MANAGER");
            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "2.0");
            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "2.0");
        }

        //if (id.getName().equals("/containers/0"))
        if (id.getName().equals("/Containers/Container1"))
        {
            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_CONTAINER");
            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "2.0");
            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "2.0");
        }

        //if (id.getName().equals("/authentication/domains/0/_MFDomainDescriptor"))
        if (id.getName().equals("/Security/Default Authentication/_MFDomainDescriptor"))
        {
            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_AUTHENTICATION_DOMAIN");
            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "2.0");
            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "2.0");
        }

        //if (id.getName().equals("/authentication/domains/0/_MFUsers"))
        if (id.getName().equals("/Security/Default Authentication/_MFUsers"))
        {
//            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_AUTHENTICATION_USER");
//            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "2.0");
//            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "2.0");
        }

        //if (id.getName().equals("/authentication/domains/0/_MFGroups"))
        if (id.getName().equals("/Security/Default Authentication/_MFGroups"))
        {
//            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_AUTHENTICATION_GROUP");
//            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "2.0");
//            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "2.0");
        }

        //if (id.getName().startsWith("/authentication/domains/0/_MFUsers/"))
        if (id.getName().startsWith("/Security/Default Authentication/_MFUsers/"))
        {
            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_AUTHENTICATION_USER");
            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "2.0");
            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "2.0");
        }

        //if (id.getName().startsWith("/authentication/domains/0/_MFGroups/"))
        if (id.getName().startsWith("/Security/Default Authentication/_MFGroups/"))
        {
            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_AUTHENTICATION_GROUP");
            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "2.0");
            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "2.0");
        }

        if (id.getName().equals("/mq/brokers/0"))
        {
            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MQ_BROKER");
            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "6.0");
            setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "6.0");
        }

        if (id.getName().startsWith("/xqFiles"))
        {
            setMetaAttribute(map, AbstractPluginAttributes.TYPE,            "MF_FILE");
            setMetaAttribute(map, AbstractPluginAttributes.CONFIG_VERSION,  "100");
            // setMetaAttribute(map, AbstractPluginAttributes.PRODUCT_VERSION, "6.0");
        }

        String newName = physicalToLogical(id.getName());
        if (!newName.equals(id.getName()))
            map.put(IConfigServer.ELEMENT_IDENTITY, new DebugElementIdentity(newName));

        return map;
    }
    */

    /**
     * Sets a meta attribute in a map only if it does NOT already exist.
     */
    private static final void setMetaAttribute(Map map, String key, Object value)
    {
        if (!map.containsKey(key))
        {
            map.put(key, value);
        }
    }

    private static final class DebugElementIdentity implements IElementIdentity
    {
        private String   m_name;
        private String[] m_components;

        public DebugElementIdentity(String path)
        {
            m_name = path;

            // skip the first separator - will always be at least one
            path = path.substring(path.indexOf('/')+1);

            ArrayList       list = new ArrayList();
            StringTokenizer st = new StringTokenizer(path, "/", true);

            while (st.hasMoreTokens())
            {
                String c     = "";
                String token = st.nextToken();

                if (!token.equals("/"))
                {
                    c = token;
                }

                list.add(c);
            }

            m_components = (String[])list.toArray(new String[list.size()]);
        }

        @Override
        public String getName() { return m_name; }
        @Override
        public String[] getNameComponents() { return m_components; }
        @Override
        public long getCreationTimestamp()  { return System.currentTimeMillis(); }
        @Override
        public long getVersion() { return 1; }
        @Override
        public String getType() { return "Element"; }
        @Override
        public String getReleaseVersion() { return "2.0"; }
        @Override
        public boolean equalVersion(IElementIdentity elementID) { return false; }
        @Override
        public boolean equalEntity(IElementIdentity elementID) { return false; }
    }

}
