/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corporation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import java.awt.event.MouseListener;

import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.event.MenuEvent;

import com.sonicsw.ma.gui.action.CopyPluginAction;
import com.sonicsw.ma.gui.action.CutPluginAction;
import com.sonicsw.ma.gui.action.PastePluginAction;
import com.sonicsw.ma.gui.action.PasteSpecialAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.gui.util.JBasicMenuItem;
import com.sonicsw.ma.plugin.IPlugin;

public class EditMenu extends JBasicMenu
{
    private static final JComponent[] DEFAULT_MENU =
    {
        new JBasicMenuItem(new CutPluginAction(null)),
        new JBasicMenuItem(new CopyPluginAction(null)),
        new JBasicMenuItem(new PastePluginAction(null)),
        new JBasicMenuItem(new PasteSpecialAction(null))
    };

    /**
     * Constructor to create the Edit action.
     * @param mouseListener
     */
    public EditMenu(MouseListener mouseListener)
    {
        super(new EditAction());

        addEditMenuMouseListener(mouseListener);
    }

    private void addEditMenuMouseListener(MouseListener mouseListener) {
        setMouseListener(mouseListener);
    }
    /**
     * Overridden method to populate the Edit menu.
     *
     * @param evt Event that caused the action to occur
     */
    @Override
    public void menuSelected(MenuEvent evt)
    {
        removeAll();

        JInternalFrame selectedFrame = MgmtConsole.getMgmtConsole().getDesktopPane().getSelectedFrame();

        JComponent[] items = null;

        if (selectedFrame != null && selectedFrame instanceof WorkspaceWindow)
        {
            WorkspaceWindow workspaceWindow = (WorkspaceWindow)selectedFrame;

            IPlugin plugin = workspaceWindow.getSelectedPlugin();

            if (plugin != null)
            {
                items = plugin.getMenuItems(IPlugin.EDIT_TYPE);
            }
        }

        if(items == null)
        {
            items = DEFAULT_MENU;
        }

        buildMenu(items);

        super.menuSelected(evt);
    }

    /**
     * Method to add an array of menu items to the Edit menu.
     *
     * @param items The array of menu items
     */
    private void buildMenu(JComponent[] items)
    {
        if (items != null && items.length > 0 && getItemCount() > 0)
        {
            addSeparator();
        }

        if (items != null && items.length > 0)
        {
            for (int i = 0; i < items.length; i++)
            {
                add(items[i]);
            }
        }
    }

    static class EditAction extends BasicGuiAction
    {
        public EditAction()
        {
            super("edit");
        }
    }
}