/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;

import javax.swing.Action;

import com.sonicsw.ma.gui.util.BasicAction;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBasicMenu;

/**
 * Context sensitive "Help" menu
 */
final class HelpMenu extends JBasicMenu
{
    private BasicAction m_helpAboutAction;

    public HelpMenu(MouseListener mouseListener)
    {
        super(new HelpAction());

        setMouseListener(mouseListener);

        m_helpAboutAction  = new HelpAboutAction();

        add(m_helpAboutAction);
    }

    public Action getHelpAboutAction()
    {
        return m_helpAboutAction;
    }

    //-------------------------------------------------------------------------
    //
    // Inner classes
    //
    //-------------------------------------------------------------------------

    static class HelpAction extends BasicGuiAction
    {
        public HelpAction()
        {
            super("help");
        }
    }

    class HelpAboutAction extends BasicGuiAction
    {
        public HelpAboutAction()
        {
            super("help.about");
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            try
            {
                JAboutDialog dialog = new JAboutDialog(MgmtConsole.getMgmtConsole());

                dialog.editInstance(null, dialog.getModel(), false);
                dialog.setVisible(true);
            }
            catch (Exception e)
            {
                MgmtConsole.displayMessage(MgmtConsole.MESSAGE_ERROR, e.toString(), e, true);
            }
        }
    }
}

