/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

/**
 * Common interface for Sonic Applications
 */
public interface IApplication
{
  public static final int MESSAGE_PROGRESS= 0;
  public static final int MESSAGE_STATUS  = 1;
  public static final int MESSAGE_INFO    = 2;
  public static final int MESSAGE_WARNING = 3;
  public static final int MESSAGE_ERROR   = 4;

  /**
   *  Notify the Application about a status message.
   *  @param message the message is expected to have been properly
   *         formatted for the current locale.
   *  @param throwable an optional accompanying throwable.
   *  @param allowDialog indicates whether or not the Application may
   *         notify the user about the message using a dialog box.
   */

  public void notifyMessage(int       type,
                            String    message,
                            Throwable throwable,
                            boolean   allowDialog);

  public void notifyMessage(int       type,
                            String    message,
                            boolean   allowDialog);

  /**
   *  Register an ApplicationListener
   */
  public void addApplicationListener(ApplicationListener listener);

  /**
   *  Unregister an ApplicationListener
   */
  public void removeApplicationListener(ApplicationListener listener);

  /**
   *  Shut down the application after notifying ApplicationListeners
   *  about the impending shutdown.  Listeners may veto the shutdown
   *  by throwing a ShutDownCancelledException.
   */
  public void shutDown() throws ShutDownCancelledException;

  /**
   *  Notify ApplicationListeners that the Application is low on memory
   *  so that they can free up resources, clear caches, etc., to allow
   *  the application to continue execution.
   */
  public void lowOnMemory();
}
