/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import com.sonicsw.mx.config.util.SonicFSFileSystem;

public interface IAssociationEditor
{
    /**
     * Initializes the editor with the Remote FS and any arguments.
     *
     * @param fs
     * @param arg
     * @throws java.lang.Exception
     */
    public void aeInit(SonicFSFileSystem fs, String[] arg)
        throws Exception;

    /**
     * Shows the editor in new file (unnamed) mode.
     *
     * @throws java.lang.Exception
     */
    public void aeNewFile()
        throws Exception;

    /**
     * Displays specified file in the editor.
     *
     * @param path
     * @throws java.lang.Exception
     */
    public void aeOpenFile(String path)
        throws Exception;

    /**
     * Saves the currently loaded file.
     *
     * @throws java.lang.Exception
     */
    public void aeSaveFile()
        throws Exception;

    /**
     * Saves the currently loaded file to a different location.
     *
     * @param path
     * @throws java.lang.Exception
     */
    public void aeSaveAsFile(String path)
        throws Exception;

    /**
     * Closes (exits) the editor.
     */
    public void aeClose();
}
