package com.sonicsw.ma.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Map;

import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import javax.swing.text.NumberFormatter;

import com.sonicsw.ma.gui.propsheets.JPropSheetTabbedDialog;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.table.RowTableColumn;
import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.ExtendedJScrollPane;
import com.sonicsw.ma.gui.util.JBasicButton;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.gui.util.JRowTable;
import com.sonicsw.ma.gui.util.ResourceManager;

public final class JAboutDialog extends JPropSheetTabbedDialog
{
    private static final String COMPANY         = "Aurea Software, Inc.";
    private static final String PRODUCT_NAME    = "Sonic Management Console";
    private static final String MQ_PRODUCT_NAME = "SonicMQ";
    private static final String COPYRIGHT       = "Copyright (c) 2015. " + COMPANY + " All Rights Reserved.";

    private JLabel m_heap;
    private javax.swing.Timer m_timer;

    public JAboutDialog(JMAFrame parent)
    {
        super(parent, "help.about", JAboutDialog.AboutModel.class);
    }

    @Override
    public Object getModel()
    {
        return new AboutModel();
    }

    @Override
    public Action[] getButtonActions()
    {
        return new Action[]
            {
            new CloseAction(getDefaultCancelAction()),
        };
    }

    @Override
    protected void maCleanup()
    {
        if (m_timer != null)
        {
            m_timer.stop();
            m_timer = null;
        }

        super.maCleanup();
    }

    @Override
    public void initUI() throws Exception
    {
        addTabPanel("About", createAboutPanel());
        addTabPanel("Info", createInfoPanel());
    }

    @Override
    public void initForm() throws Exception
    {
    }

    private JPanel createAboutPanel()
    {
        JPanel panel = new JPartitionPanel(true, "r,p,p,p,r", null, 0, 10, 10);
        panel.setBackground(Color.WHITE);

        panel.add(new JTransparentPanel());
        panel.add(new JLabel(ResourceManager.getApplicationLogo(getClass(), "logo")));
        panel.add(new JLabel(PRODUCT_NAME + " " + com.sonicsw.mf.common.Version.getVersionText(), JLabel.CENTER));
        panel.add(new JLabel(MQ_PRODUCT_NAME + " Release " + progress.message.zclient.Version.getReleaseName() + " Build Number " + progress.message.zclient.Version.getBuildNumber(), JLabel.CENTER));
        panel.add(new JLabel(COPYRIGHT, JLabel.CENTER));
        panel.add(new JTransparentPanel());

        return panel;
    }

    private JPanel createInfoPanel()
    {
        JPanel panel = new JPartitionPanel(true, "r,p", null);
        JRowTable table = new JRowTable(new TableColumn[]
                                        {new NameColumn(), new ValueColumn()}
                                        , getClass().getName());

        table.setPreferredScrollableViewportSize(new Dimension(table.getPreferredSize().width,
            table.getRowHeight() * 10));
        panel.add(new ExtendedJScrollPane(table));
        panel.add(createGCInfoPanel());

        try
        {
            Iterator i = System.getProperties().entrySet().iterator();

            while (i.hasNext())
            {
                Map.Entry entry = (Map.Entry) i.next();

                ((IModelTableModel) table.getModel()).addRow(entry);
            }
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);
            e.printStackTrace();
        }

        return panel;
    }

    private JPanel createGCInfoPanel()
    {
        JPanel panel = new JPartitionPanel(false, "p,r,p", null);

        m_heap = new JLabel(" ");

        panel.add(new JLabel("Java Heap: "));
        panel.add(m_heap);
        panel.add(new JBasicButton(new ForceGCAction()));

        ActionListener heapUpdater = new ActionListener()
        {
            @Override
            public void actionPerformed(ActionEvent evt)
            {
                Runtime r = Runtime.getRuntime();

                float usedMem = (float) (r.totalMemory() - r.freeMemory()) / 1024 / 1024;
                float totalMem = (float) r.totalMemory() / 1024 / 1024;

                try
                {
                    DecimalFormat decimalFormat = new DecimalFormat("0.0");
                    NumberFormatter textFormatter = new NumberFormatter(decimalFormat);
                    textFormatter.setOverwriteMode(true);
                    textFormatter.setAllowsInvalid(false);

                    m_heap.setText(textFormatter.valueToString(new Float(usedMem)) + "MB used, " +
                                   textFormatter.valueToString(new Float(totalMem)) + "MB allocated");
                }
                catch (Exception e)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);
                    e.printStackTrace();
                }
            }
        };
        m_timer = new javax.swing.Timer(1000, heapUpdater);

        m_timer.start();

        return panel;
    }

    //-------------------------------------------------------------------------
    //
    // Inner classes
    //
    //-------------------------------------------------------------------------

    class AboutModel
    {
        AboutModel()
        {
        }
    }

    class JTransparentPanel
        extends JPanel
    {
        public JTransparentPanel()
        {
            super();
            setProperties();
        }
        private void setProperties() {
            setOpaque(false);
        }
    }

    class NameColumn
        extends RowTableColumn
    {
        public NameColumn()
        {
            super(0, "Name", 60);
        }

        @Override
        public Object getColumnValue(Object value)
        {
            return ((Map.Entry) value).getKey();
        }
    }

    class ValueColumn
        extends RowTableColumn
    {
        public ValueColumn()
        {
            super(1, "Value", 40);
        }

        @Override
        public Object getColumnValue(Object value)
        {
            return ((Map.Entry) value).getValue();
        }
    }

    class ForceGCAction
        extends BasicGuiAction
    {
        public ForceGCAction()
        {
            super("help.about.force-gc", null);
        }

        @Override
        public void actionPerformed(ActionEvent evt)
        {
            System.gc();
        }
    }

    class CloseAction
        extends BasicGuiAction
    {
        public CloseAction(Action targetAction)
        {
            super("help.about.close", targetAction);
        }
    }
}