/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import java.awt.Component;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

import com.sonicsw.ma.gui.config.ConfigDomainFolderPlugin;
import com.sonicsw.ma.gui.config.ConfigPluginFilter;
import com.sonicsw.ma.gui.config.ConfigPluginTreeCellRenderer;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.table.IModelTableModel;
import com.sonicsw.ma.gui.util.FilterTreeModel;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.ClasspathToolInfo;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;
import com.sonicsw.ma.plugin.PluginAttributes;

public class JWorkspaceConfigPanel extends JWorkspacePanel
{
    public static final String PANEL_NAME = "Configure";

    public JWorkspaceConfigPanel()
    {
        setProperties();
    }
    
    private void setProperties() {
        setName(PANEL_NAME);
    }

    @Override
    public Icon getIcon() { return ResourceManager.getIcon(getClass(), "configure"); }

    //------------------------------------------------------------------------
    // Multi-Root support
    
    private class RootConfigPlugin extends AbstractGUIPlugin
    {
        public RootConfigPlugin(IPluginContext context)
        {
            super(context, "<not visible>");
            setProperties();
        }
        
        private void setProperties() {
            setAttributes(new PluginAttributes());
        }
        
        @Override
        public boolean expand()
        {
            return true;
        }
        
        @Override
        public Object getModel()
        {
            return null;
        }
        
        @Override
        public JPropSheetDialog getPropSheetDialog()
        {
            return null;
        }
        
        @Override
        protected JWorkspacePanel getWorkspacePanel()
        {
            return getPluginContext().getWorkspace().getWorkspacePanel(JWorkspaceConfigPanel.PANEL_NAME);
        }

        @Override
        public IPlugin goToPlugin(String path) {
            return super.goToPlugin(getCorrectConfigPath(path));
        }
    }
    
    private AbstractGUIPlugin instantiateDomainPlugin(IPluginContext context, Class pluginClass)
    {
        try
        {
            Constructor cESBDomain = pluginClass.getConstructor(new Class[] { IPluginContext.class });
            
            return (AbstractGUIPlugin)cESBDomain.newInstance(new Object[] { context });
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, "Failed to instantiate root configuration node", e, false);
        }
        return null;
    }
    
    //------------------------------------------------------------------------

    @Override
    public void initialize(IPluginContext context)
    {
        ConfigDomainFolderPlugin rootNode = new ConfigDomainFolderPlugin(context);
        rootNode.setFilter(new ConfigPluginFilter());

        if (true) // We want to pickup any of the new root node integration tools, e.g. ESB
        {
            AbstractGUIPlugin realRootNode = new RootConfigPlugin(context);
            realRootNode.add(rootNode);

            HashMap toolsMap = context.getLibrary().getToolsMap();
            Iterator i = toolsMap.entrySet().iterator();
            while (i.hasNext())
            {
                Map.Entry entry = (Map.Entry)i.next();

                if (!(entry.getValue() instanceof ClasspathToolInfo))
                {
                    continue;
                }

                ClasspathToolInfo toolInfo = (ClasspathToolInfo)entry.getValue();

                AbstractGUIPlugin rootDomainPlugin = instantiateDomainPlugin(context, toolInfo.getRootPluginClass());

                if (rootDomainPlugin != null)
                {
                    realRootNode.add(rootDomainPlugin);
                }
            }

            m_tree.setRootVisible(false);
            m_tree.setCellRenderer(new ConfigPluginTreeCellRenderer());
            m_tree.setModel(new FilterTreeModel(realRootNode, false, true));
        }
        else
        {
            m_tree.setCellRenderer(new ConfigPluginTreeCellRenderer());
            m_tree.setModel(new FilterTreeModel(rootNode, false, true));
        }
        
        // Catch the tree node expansions so that we can veto them
        // if we don't have a connection...
        //
        m_tree.addTreeWillExpandListener(new TreeWillExpandListener()
        {
            @Override
            public void treeWillExpand(TreeExpansionEvent evt)
            throws ExpandVetoException
            {
                if (!m_context.getConnectionInfo().isConnected())
                {
                    throw new ExpandVetoException(evt, "Cannot expand - no connection");
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt)
            throws ExpandVetoException
            {
            }
        });
        
        super.initialize(context);
    }
    
    @Override
    public void dispose()
    {
        super.dispose();
    }

    @Override
    public JComponent[] getMenuItems(int type)
    {
        return new JComponent[0];
    }

    @Override
    public AbstractButton[] getToolbarItems()
    {
        return new AbstractButton[0];
    }

    @Override
    public Object getSelectedItem()
    {
    	Component fc = getFocusComponent();
    	
    	if (fc instanceof JTree)
        {
            return ((JTree)fc).getSelectionPath().getLastPathComponent();
        }
    	
    	if (fc instanceof JTable)
    	{
    		int row = ((JTable)fc).getSelectedRow();
    		IModelTableModel tableModel = (IModelTableModel)((JTable)fc).getModel();
    		
    		return tableModel.getRowModel(row);
    	}
		    
        return null;
    }

    @Override
    public Object[] getSelectedItems()
    {
    	Component fc = getFocusComponent();
    	
    	if (fc instanceof JTree)
    	{
    	    TreePath[] entry = ((JTree)fc).getSelectionPaths();
    	    Object[]   res = new Object[entry.length];
    	    
    	    for (int i = 0; i < entry.length; i++)
            {
                res[i] = entry[i].getLastPathComponent();
            }
    	    
    	    return res;
    	}
    	
    	if (fc instanceof JTable)
    	{
    		int[] rows = ((JTable)fc).getSelectedRows();
    		IModelTableModel tableModel = (IModelTableModel)((JTable)fc).getModel();
    		
    		Object[] res = new Object[rows.length];
    		
    		for (int i = 0; i < res.length; i++)
            {
                res[i] = tableModel.getRowModel(rows[i]);
            }
    		
    		return res;
    	}
		    
        return null;
    }

    @Override
    protected void doExpansionImpl(final DefaultMutableTreeNode node,
            final boolean bForceRefresh,
            final boolean isSelectionChange)
    {
    	// Only expand if we are connected
    	if (!m_context.getConnectionInfo().isConnected())
        {
            return;
        }
    	
    	super.doExpansionImpl(node, bForceRefresh, isSelectionChange);
    }

    @Override
    protected String getCorrectConfigPath(String name) {
        return "/"+ ConfigDomainFolderPlugin.PLUGIN_NAME + name;
    }
}
