/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;

import com.sonicsw.ma.gui.domain.AgentManagerConnection;
import com.sonicsw.ma.gui.domain.StateChangeEvent;
import com.sonicsw.ma.gui.domain.StateChangeListener;
import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.runtime.RuntimeDomainFolderPlugin;
import com.sonicsw.ma.gui.runtime.RuntimePluginFilter;
import com.sonicsw.ma.gui.runtime.RuntimePluginTreeCellRenderer;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IPluginContext;

import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;

public class JWorkspaceRuntimePanel extends    JWorkspacePanel
                                    implements StateChangeListener
{
    public static final String PANEL_NAME = "Manage";

    private AgentManagerConnection m_agentManager;

    public JWorkspaceRuntimePanel()
    {
        setProperties();
    }
    
    private void setProperties() {
        setName(PANEL_NAME);
    }

    @Override
    public Icon getIcon()
    {
        return ResourceManager.getIcon(getClass(), "monitor1");
    }

    @Override
    public void initialize(IPluginContext context)
    {
        m_agentManager = context.getConnectionInfo().getAgentManagerConnection();

        if (m_agentManager != null)
        {
            m_agentManager.addStateChangeListener(this);
        }

        RuntimeDomainFolderPlugin rootNode = new RuntimeDomainFolderPlugin(context);
        rootNode.setFilter(new RuntimePluginFilter());

        m_tree.setCellRenderer(new RuntimePluginTreeCellRenderer());

        // Setting the initial model..a "nasty" side affect of doing this is
        // that it marks the root node as expanded without going through the
        // TreeExpansionListener mechanism.
        ((DefaultTreeModel)m_tree.getModel()).setRoot(rootNode);

        super.initialize(context);
    }

    @Override
    public void dispose()
    {
        super.dispose();

        if (m_agentManager != null)
        {
            m_agentManager.removeStateChangeListener(this);
            m_agentManager = null;
        }
    }

    @Override
    public JComponent[] getMenuItems(int type)
    {
        return new JComponent[0];
    }

    @Override
    public AbstractButton[] getToolbarItems()
    {
        return new AbstractButton[0];
    }

    @Override
    public Object getSelectedItem()
    {
        return null;
    }

    @Override
    public Object[] getSelectedItems()
    {
        return new Object[0];
    }

    //-------------------------------------------------------------------------
    //
    // StateChangeListener implementation
    //
    //-------------------------------------------------------------------------

    @Override
    public void domainStateChanged(final StateChangeEvent evt)
    {
        doStateChanged(evt);
    }

    public IPlugin getRunTimePathToPlugin(String path){
       return _getPathToPlugin(path);
    }

    private void doStateChanged(StateChangeEvent evt)
    {
        String containerPath = evt.getContainerConfigName();
        String componentName = evt.getComponentName();
        IState state         = evt.getState();

        if (containerPath == null)
        {
            return;
        }

        // get the container plugin based on the path
        AbstractRuntimePlugin containerPlugin = (AbstractRuntimePlugin)getRunTimePathToPlugin(containerPath);

        if(containerPlugin == null)
        {
            return;
        }

        synchronized (containerPlugin.getParent())
        {
            if (componentName.equals(IAgentProxy.ID))
            {
                // We have a container state change notification
                boolean refreshParentContentPane = false;

                // get the current state of the container
                IState existingState = containerPlugin.getAttributes().getState();

                // repaint container's parent content pane only if state is changed
                if (existingState == null || existingState.getState() != state.getState())
                {
                    refreshParentContentPane = true;
                }

                IIdentity id = containerPlugin.getRuntimeID();

                // if we don't already know the runtime id || it is a different
                // id to that in the event
                if (id == null ||
                    !id.getCanonicalName().equals(state.getRuntimeIdentity().getCanonicalName()))
                {
                    // refresh if the runtime name has not yet been set
                    if (state.getState() != IContainerState.STATE_UNKNOWN)
                    {
                        containerPlugin.setRuntimeID(state.getRuntimeIdentity(), state);
                        refreshParentContentPane = true;
                    }
                }

                // store the new container state in the plugin
                containerPlugin.getAttributes().setState(state);
                
                /*
                 * Earlier we used to refresh the plugin when there is load or unload 
                 * and fire node change for state change. But now doing refresh in both cases
                 * so that the tree is build appropriatly.
                 */
                
                containerPlugin.refresh();
                
                refreshContentPaneIfShown(containerPlugin);

                if (refreshParentContentPane)
                {
                    refreshContentPaneIfShown((IPlugin)containerPlugin.getParent(), containerPlugin);
                }

                    // if this tree is visible and this tree has the focus and
                    // this plugin is selected in the tree then we want to update
                    // the toolbars
                updateToolbarIfRequired(containerPlugin);
            }
            else
            {
                // We have a component state change notification
                String componentPath = containerPath + "/" + componentName;
                IPlugin plugin = getRunTimePathToPlugin(componentPath);

                if(plugin == null)
                {
                    // if we don't have a valid plugin then we might need to
                    // update the children.
                    containerPlugin.refresh();

                    // Now try to find the plugin again
                    plugin = getRunTimePathToPlugin(componentPath);
                }

                // If we have a component plugin
                if(plugin != null)
                {
                    // first update the state of the component plugin.
                    plugin.getAttributes().setState(state);

                    // instead of firing node change we are calling refresh so as to build the tree appropriatly
                    plugin.refresh();
                    refreshContentPaneIfShown(containerPlugin, plugin);
                    updateToolbarIfRequired(plugin);
                }

                // then propagate the state change up to the container
                IContainerState containerState =
                    m_agentManager.getContainerStateByRuntimeID(containerPlugin.getRuntimeID().
                    getCanonicalName());

                containerPlugin.getAttributes().setState(containerState);
                ((DefaultTreeModel)m_tree.getModel()).nodeChanged(containerPlugin);
                refreshContentPaneIfShown((IPlugin)containerPlugin.getParent(), containerPlugin);
                updateToolbarIfRequired(containerPlugin);
            }
        }
    }
}
