/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;

import com.sonicsw.ma.gui.util.BasicGuiAction;
import com.sonicsw.ma.gui.util.JBasicCheckBoxMenuItem;
import com.sonicsw.ma.gui.util.JBasicMenu;
import com.sonicsw.ma.plugin.IPlugin;

/**
 * Context sensitive "View" menu
 */
final class ViewMenu extends JBasicMenu
{
    public static String VIEW           = "view";
    public static String SHOW_TOOLBAR   = "showToolBar";
    public static String SHOW_STATUSBAR = "showStatusBar";

    private PreferenceManager m_preferences;

    private JBasicCheckBoxMenuItem m_statusBarMenuItem;
    private JBasicCheckBoxMenuItem m_messageLogMenuItem;
    private JBasicCheckBoxMenuItem m_toolBarMenuItem;


    ViewMenu(PreferenceManager preferences, MouseListener mouseListener)
    {
        super(new ViewAction());

        m_preferences = preferences;

        m_statusBarMenuItem  = new JBasicCheckBoxMenuItem(new StatusBarAction());
        m_messageLogMenuItem = new JBasicCheckBoxMenuItem(new MessageLogAction());
        m_toolBarMenuItem    = new JBasicCheckBoxMenuItem(new ToolBarAction());

        setMouseListener(mouseListener);

        buildMenu(null);

        // Set the menu item states based on the User Preferences settings.
        setMenuItemStates();
    }

    /**
     * Method to initialize the menu item states based on the User Preferences
     * settings.
     */
    protected void setMenuItemStates()
    {
        m_toolBarMenuItem.setSelected(m_preferences.getBoolean(VIEW, SHOW_TOOLBAR, true));
        m_statusBarMenuItem.setSelected(m_preferences.getBoolean(VIEW, SHOW_STATUSBAR, true));
    }

    @Override
    public void menuSelected(MenuEvent evt)
    {
        JInternalFrame innerFrame =
            MgmtConsole.getMgmtConsole().getDesktopPane().getSelectedFrame();

        JComponent[] viewItems = null;

        if (innerFrame != null && (innerFrame instanceof IWorkspaceWindow))
        {
            viewItems = ((IWorkspaceWindow)innerFrame).getSelectedMenuItems(IPlugin.VIEW_TYPE);
        }

        buildMenu(viewItems);

        super.menuSelected(evt);
    }

    boolean getShowStatus()
    {
        return m_statusBarMenuItem.isSelected();
    }

    public Action getMessageLogAction()
    {
        return m_messageLogMenuItem.getAction();
    }

    boolean getShowToolBar() { return m_toolBarMenuItem.isSelected(); }

    /**
     * Establish the contents of the view menu
     */
    private void buildMenu(JComponent[] items)
    {
        removeAll();

        add(m_toolBarMenuItem);
        add(m_statusBarMenuItem);
        addSeparator();
        add(m_messageLogMenuItem);

        if ((items != null) && (items.length > 0))
        {
            add(new JSeparator());

            for(int i=0; i<items.length; i++)
            {
                add(items[i]);
            }
        }
    }

    static class ViewAction extends BasicGuiAction
    {
        public ViewAction()
        {
            super("view");
        }
    }

    class ViewConsoleAction extends BasicGuiAction
    {
        public ViewConsoleAction()
        {
            super("view.console");
        }
    }

    static class ViewWorkspaceAction extends BasicGuiAction
    {
        public ViewWorkspaceAction()
        {
            super("view.workspace");
        }
    }

    class ToolBarAction extends BasicGuiAction
    {
        public ToolBarAction()
        {
            super("view.toolbar");
        }

        @Override
        public void actionPerformed(ActionEvent event)
        {
            MgmtConsole.getMgmtConsole().showToolBar(m_toolBarMenuItem.isSelected());

            m_preferences.setBoolean(VIEW, SHOW_TOOLBAR, m_toolBarMenuItem.isSelected(),true);
        }
    }

    class StatusBarAction extends BasicGuiAction
    {
        public StatusBarAction()
        {
            super("view.statusbar");
        }

        @Override
        public void actionPerformed(ActionEvent event)
        {
            MgmtConsole.getMgmtConsole().showStatusBar(m_statusBarMenuItem.isSelected());

            m_preferences.setBoolean(VIEW, SHOW_STATUSBAR, m_statusBarMenuItem.isSelected(), true);
        }
    }

    class MessageLogAction extends BasicGuiAction
    {
        public MessageLogAction()
        {
            super("view.messagelog");
        }

        @Override
        public void actionPerformed(ActionEvent event)
        {
            MgmtConsole.getMgmtConsole().showMessageLog(isSelected());
        }

    }
}
