/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.Helper;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IAnnotationProvider;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;

/**
 * This is the Action class used to open the annotation provider for top elements in the SMC  
 * 
 *
 */
public class AnnotationPluginAction extends BasicPluginAction
{

	private static final long serialVersionUID = 1L;

	public AnnotationPluginAction(IConfigPlugin plugin)
    {
        super(plugin, "view.annotation");
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
    	
    	 IConfigPlugin plugin = (IConfigPlugin)getPlugin();

         if (plugin.getModel() instanceof ConfigBeanModel)
         {
             IConfigBean bean = (IConfigBean)((ConfigBeanModel)plugin.getModel()).getData();

             
             //if (bean instanceof IConfigPrototype) // if (bean instanceof ConfigBeanPrototype)
             if (isTemplate(bean))
             {
            	 //System.out.println("Attempt to add or edit annotations in a template. Annotations not supported on templates");
            	 Helper.logDebugMessage("Attempt to add or edit annotations in a template. Annotations not supported on templates");
            
             }else if (bean.isPrototypeInstance()){

            	 //System.out.println("Attempt to add or edit annotations in a template instance. Annotations not supported on template instances");
            	 Helper.logDebugMessage("Attempt to add or edit annotations in a template instance. Annotations not supported on template instances");


            	 
             }else{
            	 
            
             
	             String annotation =  bean.getAnnotation();
	
	             String newAnnotation = openAnnotationEditor(annotation);
	             
	                          
	             if (annotationsChanged(annotation, newAnnotation))
	             {
	            	 //Helper.logDebugMessage("Annotations changed");
	            	 
	                 bean.setAnnotation(newAnnotation.trim().length() == 0 ? null : newAnnotation);
	
	                 IConfigServer server = bean.getConfigServer();
	                 try {
	                	 //server.storeConfigElements(new IConfigElement[] {bean}, null );
	   				
	                	 server.storeConfigElement(bean);
	                	 
	                 } catch (ConfigServiceException e) {
	   				
	               	  MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
	                             "Failed to save new annotations to server: " + getNullValidString(newAnnotation), e, true);
	               	  
	                 }
	             }
             }
             
          } 

    }

    
    protected boolean isTemplate(IConfigBean bean) {
		
		return (bean instanceof IConfigPrototype); // (bean instanceof ConfigBeanPrototype)
	}

	public final static String getNullValidString(String str)
    {
    	if (null == str)
        {
            return "null";
        }
    	
    	return str;    	
    	
    }
    

	protected boolean annotationsChanged(String annotation, String newAnnotation) {

		
		boolean retValue = false;
		
		 Helper.logDebugMessage("annotations (IN: " + getNullValidString(annotation) + ", OUT: " + getNullValidString(newAnnotation) + ")");
		 
		 
		 
		 if (annotation == newAnnotation)
		 {		 	
		 	//retValue = false;
		 
		 } else if (newAnnotation == null) {
		 	
		 	retValue =  !(annotation == null);
		 
		 }else if (null == annotation){
			 
			retValue =  !(newAnnotation == null);
		 	
		 }else if (newAnnotation.equals(annotation)){
			 
		 
			 //retValue = false;
			 
		 }else {
		 			 	
		 	retValue = true;
		 	
		 }
		 
		 if (retValue)
        {
            //System.out.println("Annotations have changed from \"" +  getNullValidString(annotation) + "\" to \"" + getNullValidString(newAnnotation) + "\"");
			 Helper.logDebugMessage("Annotations have changed from " +  getNullValidString(annotation) + " to " + getNullValidString(newAnnotation));
        }
        else
        {
            //System.out.println("Annotations have NOT changed. Old Value: \"" +  getNullValidString(annotation) + "\", value from editor:  \"" + getNullValidString(newAnnotation) + "\"" );
			 Helper.logDebugMessage("Annotations have NOT changed. Old Value: \"" +  getNullValidString(annotation) + "\", value from editor:  \"" + getNullValidString(newAnnotation) + "\"" );
        }
		 
		 return retValue;
	}
    
    protected String openAnnotationEditor(String inA) {

    	String outA = inA;
    	
        try
        {
            IConfigPlugin       plugin   = (IConfigPlugin)getPlugin();
            String              type     = plugin.getAttributes().getType();
            String              cVersion = plugin.getAttributes().getConfigVersion();
            String              pVersion = plugin.getAttributes().getProductVersion();
            IAnnotationProvider provider = getPlugin().getPluginContext().getLibrary().getAnnotationProvider(type, cVersion, pVersion);

            if (null != type)
            {
                outA = provider.openAnnotationEditor(type, cVersion, pVersion, inA, getContext().getMgmtConsole());
            }
            else
            {
                Helper.logDebugMessage("type == null, therefore a Folder, Annotations are not supported for Folders");
            }
        }
        catch(Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                "Failed to edit annotations.", e, true);
        }
        
        return outA;
	}

	@Override
    public boolean isEnabled()
    {
        IConfigPlugin       plugin   = (IConfigPlugin)getPlugin();
        String              type     = plugin.getAttributes().getType();
        String              cVersion = plugin.getAttributes().getConfigVersion();
        String              pVersion = plugin.getAttributes().getProductVersion();
        IAnnotationProvider provider = getPlugin().getPluginContext().getLibrary().getAnnotationProvider(type, cVersion, pVersion);

        if (null == provider)
        {
            return false;
        }
        
        if (!(plugin.getModel() instanceof ConfigBeanModel))
        {
            return false;
        }
        
        IConfigBean bean = (IConfigBean)((ConfigBeanModel)plugin.getModel()).getData();
        
        return ( provider.isAnnotationSupported(type, cVersion, pVersion)) 
        		&&	(! isTemplate(bean)) && (! bean.isPrototypeInstance())
        		&& (null != type);// ensure folders are not supported (is a folder when type == null)
    }
}
