/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;

import javax.swing.Action;
import javax.swing.Icon;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.ExtendedImageIcon;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.ResourceManager;
import com.sonicsw.ma.gui.util.SwingWorker;
import com.sonicsw.ma.plugin.EditPluginDialog;
import com.sonicsw.ma.plugin.IPlugin;

public class CreateFolderAction
    extends BasicPluginAction
{
    public CreateFolderAction(IPlugin plugin)
    {
        super(plugin, "file.new.folder");
        putSmallIcon();
    }
    
    private void putSmallIcon() {
        putValue(Action.SMALL_ICON, new ExtendedImageIcon((Icon) getValue(Action.SMALL_ICON), ResourceManager.getIcon(getClass(), "newoverlay")));
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        final EditPluginDialog dialog = new EditPluginDialog(MgmtConsole.getMgmtConsole());

        dialog.setVisible(true);

        if (dialog.getCloseCommand() == JMADialog.CLOSE_OK)
        {
            final String name = ((EditPluginDialog.Model)dialog.getModel()).getName();

            if (name != null && !name.trim().equals(""))
            {
                SwingWorker w = new SwingWorker()
                {
                    @Override
                    public Object construct()
                    {
                        Throwable error = null;
                        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());

                        try
                        {
                            getPlugin().getPluginContext().getConfigContext().getConfigServer().
                                createFolder(
                                new StringBuffer(getPlugin().getPluginPath()).append("/").append(
                                name).toString());
                        }
                        catch (Throwable e)
                        {
                            error = e;
                        }
                        finally
                        {
                            wc.release();
                        }

                        return error;
                    }

                    @Override
                    public void finished()
                    {
                        if (getValue() != null)
                        {
                            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, null,
                                (Throwable)getValue(), true);
                        }
                    }
                };

                w.start();
            }
            else
            {
                MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                    "No folder name specified", true);
            }
        }
    }

    @Override
    public boolean isEnabled()
    {
        return getPlugin().getPluginContext().getConnectionInfo().isConnected();
    }
}