/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPlugin;

public class CutPluginAction extends BasicPluginAction
{
    public CutPluginAction(IPlugin plugin)
    {
        super(plugin, "edit.cut");
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        try
        {
            MgmtConsole.getMgmtConsole().setClipboard(MgmtConsole.CLIP_ACTION_CUT, getPlugin());
        }
        catch (Exception e)
        {
            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                "Failed to cut configuration", e, true);
        }
    }

    @Override
    public boolean canDisplay()
    {
        return isEnabled();
    }

    @Override
    public boolean isEnabled()
    {
        IPlugin plugin = getPlugin();

        if (plugin != null && !(plugin instanceof IFolderPlugin))
        {
            return !plugin.getAttributes().isSystem();
        }

        return false;
    }
}
