/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;
import java.util.Set;

import javax.swing.JOptionPane;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.config.AbstractConfigFolderElementPlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.gui.util.SwingWorker;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IFilePlugin;
import com.sonicsw.ma.plugin.IFolderPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigPrototype;
import com.sonicsw.mx.config.IConfigServer;

public class DeletePluginAction extends BasicPluginAction
{
    private String m_name;


    public DeletePluginAction(IPlugin plugin)
    {
        this(plugin, null);
    }

    public DeletePluginAction(IPlugin plugin, String name)
    {
        super(plugin, "edit.delete");

        m_name = name;
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        if (getTargetAction() != null)
        {
            super.actionPerformed(event);
        }
        else
        {
            IPlugin plugin = getPlugin();

            boolean canTransact = true;
            String msg = null;
            final String name = (m_name == null) ? plugin.getPluginName() : m_name;

            // If we are deleting a configuration then we must
            // check that its not a template. You can't delete
            // templates until all instances have been removed!
            //
            if (plugin.getModel() instanceof ConfigBeanModel)
            {
                IConfigBean bean = (IConfigBean)((ConfigBeanModel)plugin.getModel()).getData();

                // Sonic00020697
                // Check to see if the configuration is currently deployed and
                // running...if so, we want a more specific warning...
                //
                String path = (plugin instanceof AbstractConfigFolderElementPlugin) ? ((AbstractConfigFolderElementPlugin)plugin)._getPluginPath() : plugin.getPluginPath();
                if (plugin.getPluginContext().getConnectionInfo().getAgentManagerConnection().activeComponentExists(path))
                {
                    msg = "Configuration '" + name + "' is deployed and running.\nAre you sure you want to delete it?";
                }

                // If we are dealing with a prototype (template) or an
                // instance of a template then we can't use a transacted
                // ConfigServer because touching either of these types of
                // configuration will result in config version update
                // side-affects...that will break the commit.
                //
                if ((bean instanceof IConfigPrototype) || bean.isPrototypeInstance())
                {
                    canTransact = false;
                }

                if (bean instanceof IConfigPrototype)
                {
                    IConfigPrototype prototype = (IConfigPrototype)bean;

                    try
                    {
                        if (prototype.getPrototypeInstances().size() > 0)
                        {
                            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_WARNING,
                                    "Can't delete template configuration because linked instances still exist!", true);
                            return;
                        }
                    }
                    catch (ConfigServiceException e)
                    {
                        MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, e.getMessage(), e, false);
                    }
                }
            }
            else
            if (plugin instanceof IFolderPlugin)
            {
                // Attempting to delete a folder so check that it is empty
                try
                {
                    IConfigServer configServer = getPlugin().getPluginContext().getConfigContext().getConfigServer();
                    String        path         = plugin.getPluginPath();

                	Set set = configServer.list(path);
                	if (set != null && !set.isEmpty())
                	{
                		if (plugin instanceof IFilePlugin)
                		{
                			msg  = "Are you sure you want to delete the folder '" +
							       plugin.getPluginName() +
							       "' and all its contents";
                		}
                		else
                		{
                			MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_WARNING,
                				"Can't delete folder because it isn't empty.", true);
                			return;
                		}
                	}
                }
                catch(ConfigServiceException e)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR, e.getMessage(), e, false);
                }
            }

            final boolean transacted = canTransact;

            int ok = MgmtConsole.getMgmtConsole().showConfirmDialog(MgmtConsole.getMgmtConsole(),
                (msg != null) ? msg : "Are you sure you want to delete '" + name + "'",
                "Delete Confirmation",
                JOptionPane.QUESTION_MESSAGE,
                JOptionPane.YES_NO_OPTION);

            if(ok == JOptionPane.YES_OPTION)
            {
                SwingWorker w = new SwingWorker()
                {
                    @Override
                    public Object construct()
                    {
                        Throwable error = null;

                        JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());

                        IConfigServer configServer = null;
                        
                        try
                        {
                            // We don't always want to use a transaction
                            // (see config delete comment above)
                        	configServer = transacted ? getPlugin().getPluginContext().getConfigContext().getConfigServer().connectTransacted()
                        	                          : getPlugin().getPluginContext().getConfigContext().getConfigServer().connect();
                        	
                           getPlugin().deletePlugin(configServer);

                            if (configServer.isTransacted())
                            {
                                configServer.commit();
                            }

                            // If we are deleting the plugin that is currently
                            // sat on the clipboard then we should clear it out.
                            //
                            if (MgmtConsole.getMgmtConsole().getClipboardObject() == getPlugin())
                            {
                                MgmtConsole.getMgmtConsole().clearClipboard();
                            }
                        }
                        catch (Exception e)
                        {
                            error = e;
                        }
                        finally
                        {
                        	if (configServer != null)
                        	{
                        		try { 
                        		    configServer.close(); 
                        		} catch (Exception e) {
                        		    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);
                        		}
                        	}
                        	
                            wc.release();
                        }

                        return error;
                    }

                    @Override
                    public void finished()
                    {
                        if (getValue() != null)
                        {
                            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.
                                MESSAGE_ERROR,
                                "Failed to delete configuration '" + name + "'", (Throwable)getValue(), true);
                        }
                    }
                };

                w.start();
            }
        }
    }

    @Override
    public boolean canDisplay()
    {
        return isEnabled();
    }

    @Override
    public boolean isEnabled()
    {
        IPlugin plugin = getPlugin();

        if (plugin != null)
        {
            return !plugin.getAttributes().isSystem();
        }

        return false;
    }
}
