/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IRuntimePlugin;


public class GoToConfigurationAction extends BasicPluginAction
{
    public GoToConfigurationAction(IPlugin plugin)
    {
        super(plugin, "view.gotoconfiguration");
    }

    public GoToConfigurationAction(IPlugin plugin, Action targetAction)
    {
        super(plugin.getPluginContext(), plugin, targetAction, "view.gotoconfiguration" );
    }

    @Override
    public boolean isEnabled()
    {
        boolean res = super.isEnabled();

        IPlugin plugin = (IPlugin)getPlugin();

        if (plugin == null)
        {
            return res;
        }

        boolean      isStateable = plugin.getAttributes().isStateable();
        String              type = plugin.getAttributes().getType();

        if (getTargetAction() == null && type != null)
        {
            res = isStateable;
        }

        // Gotta catch the situation where a newly created configuration
        // doesn't have a runtime id yet.
        if (plugin instanceof IRuntimePlugin && (res && (((IRuntimePlugin)plugin).getRuntimeID() == null)))
        {
            res = false;
        }
        
        return res;
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        if (getTargetAction() == null)
        {
            ((AbstractRuntimePlugin)getPlugin()).goToConfiguration();
        }
        else
        {
            super.actionPerformed(event);
        }
    }
}
