/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;

import javax.swing.Action;

import com.sonicsw.ma.gui.config.AbstractConfigFolderElementPlugin;
import com.sonicsw.ma.gui.config.AbstractConfigPlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;

public class GoToInstanceAction extends BasicPluginAction
{
    public GoToInstanceAction(IPlugin plugin)
    {
        super(plugin, "view.gotoinstance");
    }

    public GoToInstanceAction(IPlugin plugin, Action targetAction)
    {
        super(plugin.getPluginContext(), plugin, targetAction, "view.gotoinstance" );
    }

    @Override
    public boolean isEnabled()
    {
        if (getTargetAction() == null)
        {
            IConfigPlugin plugin = (IConfigPlugin)getPlugin();
            String        type   = plugin.getAttributes().getType();
            boolean       isComponent = plugin.getAttributes().isComponent();

            if (plugin != null && type != null)
            {
                if (type.equals("MF_CONTAINER"))
                {
                    return getContext().getConnectionInfo().getAgentManagerConnection().
                        containerExists(plugin.getPluginPath());
                }

                if(isComponent)
                {
                    String path = plugin.getPluginPath();

                    if (plugin instanceof AbstractConfigFolderElementPlugin)
                    {
                        path = ((AbstractConfigFolderElementPlugin)plugin)._getPluginPath();
                    }

                    return getContext().getConnectionInfo().getAgentManagerConnection().
                        activeComponentExists(path);
                }
            }
            return false;
        }
        return getTargetAction().isEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        if (getTargetAction() == null)
        {
            ((AbstractConfigPlugin)getPlugin()).goToInstance();
        }
        else
        {
            super.actionPerformed(event);
        }
    }
}
