/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */

package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.PreferenceManager;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.mx.config.ConfigServerUtility;

public class ImportPluginAction extends BasicPluginAction
{
    public ImportPluginAction(IConfigPlugin plugin)
    {
        super(plugin, "import.plugin");
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        PreferenceManager pm = PreferenceManager.getInstance();
        String basePath = pm.getString(ExportPluginAction.BOOT_PATH_PREFS, ExportPluginAction.BASEPATH, "");

        JFileChooser fc = new JFileChooser();

        fc.setDialogTitle("Select Import Path");
        fc.setApproveButtonText("Import");
        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        fc.setSelectedFile(new File(basePath));

        if (fc.showOpenDialog(MgmtConsole.getMgmtConsole()) == JFileChooser.APPROVE_OPTION)
        {
            String path = fc.getSelectedFile().getPath();

            pm.setString(ExportPluginAction.BOOT_PATH_PREFS, ExportPluginAction.BASEPATH, path, true);

            if (MgmtConsole.getMgmtConsole().showConfirmDialog(
                "Are you sure you want to import configuration(s) from '" + path +
                "'?\r\nThis will overwrite any existing configurations with the same names.",
                "Import Configurations",
                JOptionPane.QUESTION_MESSAGE, JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
            {
                importPath(path);
            }
        }
    }

    private void importPath(final String path)
    {
        Thread t = new Thread(new Runnable()
        {
            @Override
            public void run()
            {
                JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());

                try
                {
                    ConfigServerUtility csu = getPlugin().getPluginContext().
                        getConnectionInfo().getConfigServerUtility();

                    csu.importBeanPath(path, true);
                    csu.repairDanglingBeanReferences();
                }
                catch (Exception e)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.MESSAGE_ERROR,
                        "Failed to import configurations.", e, true);
                }
                finally
                {
                    wc.release();
                }
            }
        });

        t.start();
    }
}