/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;

import javax.swing.Action;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.IConfigBean;


public class PasteSpecialAction extends PastePluginAction
{
    public PasteSpecialAction(IPlugin plugin)
    {
        super(plugin, "edit.paste.special");

        // check what (if anything) is on the clipboard and change the text
        // according to the type (instance or template)

        if(plugin != null)
        {
            Object obj = MgmtConsole.getMgmtConsole().getClipboardObject();

            if(obj != null && obj instanceof IConfigPlugin)
            {
                if (((IConfigPlugin)obj).isTemplatePrototype())
                {
                    putNameValue("Paste as Configuration");
                }
                else
                {
                    putNameValue("Paste as Template");
                }
            }
        }
    }

    private void putNameValue(String value) {
        putValue(Action.NAME, value);
    }
    
    @Override
    public void actionPerformed(ActionEvent event)
    {
        paste(true);
    }

    @Override
    public boolean isEnabled()
    {
        boolean res = super.isEnabled();

        if (!res)
        {
            return res;
        }

        // Don't support conversion between types if the data in the
        // clipboard was cut rather than copied
        if (MgmtConsole.getMgmtConsole().getClipboardAction() == MgmtConsole.CLIP_ACTION_CUT)
        {
            res = false;
        }
        else
        if (MgmtConsole.getMgmtConsole().isClipboardDataFlavorSupported(MgmtConsole.configFlavor))
        {
            IConfigPlugin pastePlugin = (IConfigPlugin)MgmtConsole.getMgmtConsole().getClipboardObject();

            if (pastePlugin.isTemplatePrototype())
            {
                res = true;
            }
            else
            if (pastePlugin.isTemplateInstance())
            {
                res = false;
            }
            else
            {
                //check first if plugin factory template setting supressed by meta attributes setting
                //example: FT container can't be templatable, even factory supports it for normal container
                try
                {
                    IConfigBean bean = (IConfigBean)((ConfigBeanModel)pastePlugin.getModel()).getData();
                        
                    if (bean != null)
                    {
                        HashMap attrs = bean.getMetaAttributes();
                        if (attrs.containsKey(ConfigServerUtility.EXCLUDE_TEMPLATE_TYPE))
                        {
                            return false;
                        }
                    }
                }
                catch (Exception e) { //nothing to do just log the error.
                    MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);
                }
                  
                // We should only be able to paste as a template if the plugin
                // factory supports that capability...
                //
                res = pastePlugin.getAttributes().isTemplatable();
            }
        }
        else
        if (MgmtConsole.getMgmtConsole().isClipboardDataFlavorSupported(MgmtConsole.fileFlavor))
         {
            res = false;  // Nothing special to do with pasting a file!
        }

        return res;
    }
}
