// Copyright (c) 2002, 2007 Progress Software Corporation. All Rights Reserved.

package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;

import javax.swing.tree.TreeNode;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.perms.ManagementSecurityUtils;
import com.sonicsw.ma.gui.propsheets.JPropSheetDialog;
import com.sonicsw.ma.gui.runtime.AbstractRuntimePlugin;
import com.sonicsw.ma.gui.runtime.propsheets.RuntimeBean;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.GUIException;
import com.sonicsw.ma.gui.util.JWaitCursor;
import com.sonicsw.ma.plugin.ConfigBeanModel;
import com.sonicsw.ma.plugin.IConfigPlugin;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.ma.plugin.IRuntimePlugin;
import com.sonicsw.mx.config.ConfigServerFactory;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigServer;

import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.security.IManagementSecurityConfigurator;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;

public class PropSheetAction extends BasicPluginAction
{
    public PropSheetAction(IPlugin plugin)
    {
        super(plugin, "edit.properties");
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        if (isEnabled())
        {
            Thread t = new Thread(new Runnable()
            {
                @Override
                public void run()
                {

                	JWaitCursor wc = new JWaitCursor(MgmtConsole.getMgmtConsole());
                    IApplication app = getContext().getMgmtConsole();

                    try
                    {
                        IPlugin plugin = getPlugin();
                        
                        checkReadDenied(plugin);
                        
                        JPropSheetDialog dialog = plugin.getPropSheetDialog();

                        if (dialog == null)
                        {
                            return;
                        }

                        if (dialog.getEditForm().getModelDescriptor().getModelType() == null)
                        {
                            app.notifyMessage(IApplication.MESSAGE_ERROR,
                                "Meta data not available for Properties dialog",
                                true);
                            dialog.dispose();
                        }
                        else
                        {
                            Object model = plugin.getModel();

                            if (plugin instanceof IConfigPlugin && model instanceof ConfigBeanModel)
                            {
                                // Create transacted server...we then have to make
                                // a transacted config bean model (i.e. one where
                                // the IConfigBean was loaded through the transacted
                                // server) and use that for the dialog edit...
                                //
                                IConfigServer server = ConfigServerFactory.
                                    connectTransactedConfigServer(plugin.getPluginContext().
                                    getConnectionInfo().getDirectoryService());
                                IConfigBean mBean = (IConfigBean)((ConfigBeanModel)model).getData();
                                IConfigBean tBean = (IConfigBean)server.loadConfigElement(mBean.
                                    getName());

                                model = new ConfigBeanModel(tBean, plugin.getPluginName());
                            }

                            if (model == null)
                            {
                                try {
                                    app.notifyMessage(IApplication.MESSAGE_ERROR,
                                            "Failed to get model data for Properties dialog", true);
                                } finally {
                                    dialog.dispose();
                                }
                            }
                            else
                            {
                                dialog.editInstance(plugin, model, false);
                                dialog.setVisible(true);
                            }
                        }
                    }
                    catch (GUIException e)
                    {
                        app.notifyMessage(IApplication.MESSAGE_WARNING,
                                          e.getMessage(),
                                          e,
                                          true);
                    }
                    catch (Exception e)
                    {
                        Throwable cause = e.getCause();
                        if(!(cause instanceof ManagementPermissionDeniedException))
                        {
                            cause = e;
                        }
                        app.notifyMessage(IApplication.MESSAGE_ERROR,
                                          "Could not launch Properties dialog.",
                                          cause,
                                          true);
                    }
                    finally
                    {
                        wc.release();
                    }
                }

            });

            t.start();
        }
    }


    @Override
    public boolean isEnabled()
    {
        if (getPlugin()instanceof IRuntimePlugin)
        {
            IState state = getPlugin().getAttributes().getState();

            if (state == null)
            {
                return true;
            }

            // we either have a container or a component
            if (state instanceof IContainerState)
            {
                if (state.getState() == IContainerState.STATE_ONLINE ||
                    state.getState() == IContainerState.STATE_UNKNOWN)
                {
                    return true;
                }
            }
            else if (state instanceof IComponentState)
            {
                TreeNode parent = ((TreeNode) getPlugin()).getParent();

                if (parent == null || !(parent instanceof IRuntimePlugin))
                {
                    return false;
                }

                IPlugin parentPlugin = (IPlugin) parent;
                IState parentState = parentPlugin.getAttributes().getState();

                if ((parentState.getState() == IContainerState.STATE_ONLINE) ||
                    (parentState.getState() == IContainerState.STATE_UNKNOWN))
                {
                    return true;
                }
            }
        }
        else
        {
            // Properties will only be available if we are currently connected
            return getPlugin().getPluginContext().getConnectionInfo().isConnected();
        }
        return false;
    }

    private void checkReadDenied(IPlugin plugin) throws Exception {
    	try { 		    		    		    		
    		if ( ManagementSecurityUtils.allowsConfigPerms(plugin)){
                // check here if the model was null because read was denied.
                // If yes, getManagementPermissions(...) will fail, causing a correct error message presentation.
        		IManagementSecurityConfigurator mgmtSecConftor = ((IManagementSecurityConfigurator) plugin.getPluginContext().getConnectionInfo().getDirectoryService());
            	mgmtSecConftor.getManagementPermissions(new String[]{getPluginPath()}, IManagementPermission.CONFIGURE_TYPE);
            }
            if ( ManagementSecurityUtils.hasManagePerms(plugin) && plugin instanceof AbstractRuntimePlugin ){
            	//Checking for the manage permission. If the user is denied GETINFO perm 
            	//throws ManagementPermissionDeniedException.
            	RuntimeBean model = (RuntimeBean) plugin.getModel();
            	IRemoteMBeanServer remoteMBeanServer = model.getServer();
            	remoteMBeanServer.getMBeanInfo(model.getName());
            }
        }catch (ManagementPermissionDeniedException me) {
            throw me;
        }catch (Exception e) {
            // fail silently
            MgmtConsole.getMgmtConsole().notifyMessage(MgmtConsole.ERROR, e.getMessage(), e, false);
        }
    }

    private String getPluginPath() {    	
        return getPlugin().getPluginPath();
    }

}