/**
 * Copyright (c) 2002 Sonic Software Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sonic
 * Software Corpoation. (Confidential Information).  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sonic.
 *
 * SONIC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SONIC SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * CopyrightVersion 1.0
 */
package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;

import com.sonicsw.ma.gui.IApplication;
import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.plugin.AbstractGUIPlugin;
import com.sonicsw.ma.plugin.EditPluginDialog;
import com.sonicsw.ma.plugin.IPlugin;
import com.sonicsw.mx.config.ConfigServerFactory;
import com.sonicsw.mx.config.IConfigServer;

public class RenamePluginAction extends BasicPluginAction
{
    public RenamePluginAction(IPlugin plugin)
    {
        super(plugin, "edit.rename");
    }

    @Override
    public void actionPerformed(ActionEvent event)
    {
        EditPluginDialog dialog = new EditPluginDialog(MgmtConsole.getMgmtConsole(), EditPluginDialog.MODE_EDIT, getPlugin());

        dialog.setVisible(true);

        if (dialog.getCloseCommand() != JMADialog.CLOSE_OK)
        {
            return;
        }

        String name = ((EditPluginDialog.Model)dialog.getModel()).getName().trim();

        if (!name.trim().equals(""))
        {
            try
            {
                String oldPath = getPlugin().getPluginPath();
                int    index   = oldPath.lastIndexOf('/');
                String newPath = oldPath.substring(0, index) + "/" + name;
                
                boolean bExist = ((AbstractGUIPlugin)getPlugin()).pathExists(newPath);
                 
                if (bExist) //could be change case only
                {
                    if (!oldPath.equals(newPath) && oldPath.equalsIgnoreCase(newPath))
                    {
                        IConfigServer server = ConfigServerFactory.connectTransactedConfigServer(getPlugin().getPluginContext().getConnectionInfo().getDirectoryService());

                        getPlugin().renamePlugin(server, newPath);

                        server.commit();
                    }  
                    else
                    {
                        MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                                "The specified name already exists", true);
                    }
                        
                }
                else
                {
                    IConfigServer server = ConfigServerFactory.connectTransactedConfigServer(getPlugin().getPluginContext().getConnectionInfo().getDirectoryService());

                    getPlugin().renamePlugin(server, newPath);

                    server.commit();
                }
              
            }
            catch (Throwable e)
            {
                if (e instanceof UnsupportedOperationException)
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                                                               e.getMessage(), e, false);
                }
                else
                {
                    MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                                                               e.getMessage(), e, true);
                }
            }
        }
        else
        {
            MgmtConsole.getMgmtConsole().notifyMessage(IApplication.MESSAGE_ERROR,
                                                       "No name specified", true);
        }
    }

    @Override
    public boolean canDisplay()
    {
        return isEnabled();
    }

    @Override
    public boolean isEnabled()
    {
        IPlugin plugin = getPlugin();

        if (plugin != null)
        {
            return !plugin.getAttributes().isSystem();
        }

        return false;
    }
}
