// Copyright (c) 2009 Progress Software Corporation. All Rights Reserved.
package com.sonicsw.ma.gui.action;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.runtime.RuntimeDomainFolderPlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.plugin.IPlugin;

import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;

/**
 * <p>Title: RuntimeClearLogAction</p>
 * <p>Description: Creates an Action to Clear Centralized Log </p>
 * @author Chandana Konda
 *
 */
public class RuntimeClearLogAction extends BasicPluginAction
{
	IPlugin plugin = null;
    public RuntimeClearLogAction(IPlugin plugin)
    {
    	super(plugin, "runtime.clearlog");
    	this.plugin = plugin;
    }
	@Override
    public void actionPerformed(ActionEvent evt) 
	{
		String prompt = "Are you sure you want to clear the active central log file?";
        int ok = MgmtConsole.getMgmtConsole().showConfirmDialog(prompt,
                            "Perform operation",
                            JOptionPane.QUESTION_MESSAGE,
                            JOptionPane.YES_NO_OPTION);
        if(ok == JOptionPane.YES_OPTION)
        {
            if(plugin instanceof RuntimeDomainFolderPlugin)
            {
            	DomainConnectionModel domainModel = plugin.getPluginContext()
            	.getConnectionInfo();
            	IAgentManagerProxy agentManager = domainModel.getAgentManager();
            	agentManager.clearLogFile();
            }
        }
	}
    @Override
    public boolean isEnabled()
    {
    	return true;
    }
}