// Copyright (c) 2009 Progress Software Corporation. All Rights Reserved.
package com.sonicsw.ma.gui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;

import javax.swing.JLabel;
import javax.swing.JTextField;

import com.sonicsw.ma.gui.MgmtConsole;
import com.sonicsw.ma.gui.domain.DomainConnectionModel;
import com.sonicsw.ma.gui.runtime.RuntimeDomainFolderPlugin;
import com.sonicsw.ma.gui.util.BasicPluginAction;
import com.sonicsw.ma.gui.util.JMADialog;
import com.sonicsw.ma.gui.util.JMAFrame;
import com.sonicsw.ma.gui.util.JPartitionPanel;
import com.sonicsw.ma.plugin.IPlugin;

import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;

/**
 * <p>Title: RuntimeSaveLogFileAction</p>
 * <p>Description: Creates an Action to save centralized log to file</p>
 * @author Chandana Konda
 *
 */
public class RuntimeSaveLogFileAction extends BasicPluginAction
{
	IPlugin plugin = null;
    public RuntimeSaveLogFileAction(IPlugin plugin)
    {
    	super(plugin, "runtime.savelog");
    	this.plugin = plugin;
    }

    @Override
    public void actionPerformed(ActionEvent evt)
    {
        JSaveLogDialog dialog = new JSaveLogDialog(MgmtConsole.
            getMgmtConsole());
        dialog.setVisible(true);
        if (dialog.getCloseCommand() == JMADialog.CLOSE_OK)
        {
            String name = dialog.getLogFileName();

            if ((name != null) && !name.trim().equals(""))
            {
            	if(plugin instanceof RuntimeDomainFolderPlugin)
            	{
	            	DomainConnectionModel domainModel = plugin.getPluginContext()
					.getConnectionInfo();
	            	IAgentManagerProxy agentManager = domainModel.getAgentManager();
	            	agentManager.saveLogFile(name);
            	}
            }
        }
    }

    @Override
    public boolean isEnabled()
    {
    	 return true;
    }

    class JSaveLogDialog extends JMADialog
    {
        private JTextField m_filename = new JTextField();
        private JPartitionPanel m_panel;

        public JSaveLogDialog(JMAFrame parent)
        {
            super(parent, "runtime.savelog");
            prepareJSaveLogDialog();
        }
        
        private void prepareJSaveLogDialog() {
            setResizable(false);

            ((BorderLayout) getContentPane().getLayout()).setVgap(5);
            m_panel = new JPartitionPanel(false, "r", "");

            super.getContentPane().add(m_panel);
        }

        @Override
        protected void maInitialize()
        {
            m_panel.add(new JLabel(
                "Enter the filename where the central log file should be saved."));
            m_panel.add(new JLabel());
            m_panel.add(new JLabel(
                "NOTE: The file will be saved relative to the machine hosting this container."));
            m_panel.add(JPartitionPanel.merge("p,r",
                                              false,
                                              JPartitionPanel.DEFAULT_GAP_SIZE,
                                              JPartitionPanel.
                                              DEFAULT_TB_EDGE_GAP,
                                              0,
                                              new Component[]
                                              {new JLabel("Filename:"),
                                              m_filename}));
        }

        @Override
        protected void maCleanup()
        {
        }

        public String getLogFileName()
        {
            return m_filename.getText().trim();
        }
    }
}